(function () {
	CKEDITOR.plugins.add("slashcommand", {
		init: function (editor) {
			if (editor.addMenuItems) {
				editor.addMenuGroup("slashcommand");
			}

			editor.on("change", function () {
				var selection = editor.getSelection();
				var element = selection.getStartElement();

				if (element && /^\/$/.test(element.$.textContent)) {
					editor.contextMenu.open(element);
					editor.once("menuShow", function () {
						element.$.textContent = "";
					});
				}
			});
		}
	});

	CKEDITOR.SLASHCOMMAND = "slashcommand";
})();
