package com.arms.api.mapping.dto;

import com.arms.api.mapping.domain.StateCategory;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;


@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class StateCategoryDTO {

    @Id
    private String id;

    private String name;

    public StateCategory toEntity(){
        return StateCategory.builder()
            .id(this.id)
            .name(this.name)
            .build();
    }
}