package com.arms.api.mapping.service;

import com.arms.api.mapping.domain.State;
import com.arms.api.mapping.domain.StateCategory;
import com.arms.api.mapping.repository.StateCategoryRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class StateCategoryService {

    private final StateService stateService;
    private final StateCategoryRepository stateCategoryRepository;

    public void init(List<StateCategory> stateCategoryList) {
        stateCategoryRepository.saveAll(stateCategoryList);
    }

    public void deleteStateCategory() { stateCategoryRepository.deleteAll(); }

    public StateCategory getArmsStateCategoryByStateId(String stateId) {

        if (stateId == null) {
            return null;
        }

        State state = stateService.getArmsStateById(stateId);

        if (state == null || state.getCategoryMappingId() == null) {
            return null;
        }

        String categoryMappingId = state.getCategoryMappingId();
        StateCategory stateCategory = stateCategoryRepository.findById(categoryMappingId)
                .orElseGet(() -> StateCategory.builder().build());

        return stateCategory;
    }

    public StateCategory getArmsStateCategory(String categoryId) {

        StateCategory stateCategory = stateCategoryRepository.findById(categoryId).orElse(null);

        return stateCategory;
    }
}