package com.arms.config.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class BlockRequestGatewayFilter extends AbstractGatewayFilterFactory<BlockRequestGatewayFilter.Config> {

	private final PermitUrl permitUrl;

	public BlockRequestGatewayFilter(PermitUrl permitUrl) {
		super(Config.class);
		this.permitUrl = permitUrl;
	}

	@Override
	public GatewayFilter apply(Config config) {
		return (exchange, chain) -> {
			String path = exchange.getRequest().getURI().getPath();
			boolean isPermitted = false;

			for (String permitUrl : permitUrl.getUrls()) {
				if (path.contains(permitUrl)) {
					isPermitted = true;
					break;
				}
			}
			if (!isPermitted) {
				return exchange.getResponse().setComplete();
			}
			return chain.filter(exchange);
		};
	}

	public static class Config {
		private Config() {
		}
	}

	@Override
	public String name() {
		return "BlockRequestGatewayFilter";
	}


}
