// authUserCheck();
let pocId = null;
let currentPocData = null;
////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	// 관리자 권한 체크 - 권한이 없으면 리다이렉트
	checkAdminAccess(function() {
		var pluginGroups = [
			["./css/poc/poc-admin-detail.css"],
			["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
			["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"],
			[
				"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
				"../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js"
			]
		];

		loadPluginGroupsParallelAndSequential(pluginGroups)
			.then(function () {
				console.log("모든 플러그인 로드 완료");

				$(".widget").widgster();
				$('.selectpicker').selectpicker();
				$("#sidebar").hide();
				$(".wrap").css("margin-left", 0);
				$("#footer").load("/cover/html/template/landing-footer.html");

				pocId = getUrlParameter('id');
				if (pocId) {
					loadPocDetail(pocId);
				} else {
					window.location.href = '/cover/template.html?page=pocAdmin';
				}

				select2_setting();

				bindEvents();
			})
			.catch(function (error) {
				console.error("플러그인 로드 중 오류 발생");
				console.error(error);
			});
	});
}

function getUrlParameter(name) {
	name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
	var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
	var results = regex.exec(location.search);
	return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}

function loadPocDetail(id) {
	$.ajax({
		url: '/auth-anon/api/arms/poc/getPoc.do/' + id,
		type: 'GET',
		success: function(result) {
			console.log('API Response:', result);

			if (result && result.success && result.response) {
				populateForm(result.response);
			} else {
				window.location.href = '/cover/template.html?page=pocAdmin';
			}
		},
		error: function(xhr, status, error) {
			console.error('POC 데이터 로드 실패:', error);
		}
	});
}

function populateForm(data) {
	currentPocData = data;
	$('#poc-id').val(data.id);
	$('#poc-full-name').val(data.c_poc_full_name || '');
	$('#poc-company-name').val(data.c_poc_company_name || '');
	$('#poc-job-title').val(data.c_poc_job_title || '');
	$('#poc-email').val(data.c_poc_email_address || '');
	$('#poc-contact').val(data.c_poc_contact_number || '');
	$('#poc-country').val(data.c_poc_country || '');
	$('#poc-company-size').val(data.c_poc_company_size || '');
	if (data.c_poc_inquiry_date) {$('#poc-inquiry-date').val(formatDate(data.c_poc_inquiry_date));}
	$('#poc-inquiry-reason').val(data.c_poc_inquiry_reason || '');
	$('#poc-inquiry-content').val(data.c_poc_inquiry_content || '');
	$('#poc-marketing-consent').val(data.c_poc_marketing_consent ? '동의' : '미동의');
	$('#poc-status').val(data.c_poc_status || 'pending');
	$('#poc-assignee-id').val(data.c_poc_assignee_id || '');
	$('#poc-assignee-notes').val(data.c_poc_assignee_notes || '');
}

function formatDate(dateObj) {
	if (!dateObj) return '';

	if (typeof dateObj === 'object' && dateObj.year) {
		return dateObj.year + '-' +
			String(dateObj.monthValue).padStart(2, '0') + '-' +
			String(dateObj.dayOfMonth).padStart(2, '0');
	}

	try {
		let date = new Date(dateObj);
		if (!isNaN(date.getTime())) {
			return date.toISOString().split('T')[0];
		}
	} catch (e) {
		console.error("날짜 파싱 실패:", e);
	}

	return '';
}

function bindEvents() {
	$('#poc-detail-form').on('submit', function(e) {
		e.preventDefault();
		savePocDetail();
	});
}

function savePocDetail() {
	if (!currentPocData) return;

	const selectedUserData = $('.js-data-example-ajax').select2('data')[0];
	let assigneeId = null;
	let assigneeUsername = null;
	let assigneeName = null;
	let assigneeEmail = null;

	if (selectedUserData) {
		assigneeId = selectedUserData.id;
		assigneeUsername = selectedUserData.username;
		assigneeName = (selectedUserData.firstName || '') + ' ' + (selectedUserData.lastName || '');
		assigneeName = assigneeName.trim() || null;
		assigneeEmail = selectedUserData.email || null;
	}

	let formData = {
		id: currentPocData.id,
		c_poc_first_name: currentPocData.c_poc_first_name,
		c_poc_last_name: currentPocData.c_poc_last_name,
		c_poc_full_name: currentPocData.c_poc_full_name,
		c_poc_company_name: currentPocData.c_poc_company_name,
		c_poc_company_size: currentPocData.c_poc_company_size,
		c_poc_job_title: currentPocData.c_poc_job_title,
		c_poc_email_address: currentPocData.c_poc_email_address,
		c_poc_country: currentPocData.c_poc_country,
		c_poc_contact_number: currentPocData.c_poc_contact_number,
		c_poc_inquiry_reason: currentPocData.c_poc_inquiry_reason,
		c_poc_inquiry_content: currentPocData.c_poc_inquiry_content,
		c_poc_marketing_consent: currentPocData.c_poc_marketing_consent,
		c_poc_status: $('#poc-status').val(),
		c_poc_assignee_id: assigneeId,
		c_poc_assignee_username: assigneeUsername,
		c_poc_assignee_name: assigneeName,
		c_poc_assignee_email: assigneeEmail,
		c_poc_assignee_notes: $('#poc-assignee-notes').val() || null
	};

	$.ajax({
		url: '/auth-anon/api/arms/poc/updatePoc.do',
		type: 'put',
		data: formData,
		statusCode: {
			200: function() {
				console.log('Update successful');
				window.location.href = '/cover/template.html?page=pocAdmin';
			}
		},
		error: function(xhr, status, error) {
			console.error('저장 실패:', error);
			console.error('Response:', xhr.responseText);
		}
	});
}

function clearAssignee() {
	$('#poc-assignee-id').val('');
}

// 삭제 확인
function deletePoc() {
	$('#deleteModal').modal('show');
}

function confirmDelete() {
	$.ajax({
		url: '/auth-anon/api/arms/poc/removePoc.do/' + pocId,
		type: 'DELETE',
		success: function(response) {
			window.location.href = '/cover/template.html?page=pocAdmin';
		},
		error: function(xhr, status, error) {
			console.error('삭제 실패:', error);
		}
	});
}

function checkAdminAccess(callback) {
	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				console.log("[ POC Admin Detail :: authUserCheck ] userName = " + json.preferred_username);
				console.log("[ POC Admin Detail :: authUserCheck ] roles = " + json.realm_access.roles);

				var permissions = json.realm_access.roles;

				if (permissions && permissions.indexOf("ROLE_ADMIN") != -1) {
					if (callback) callback();
				} else {
					window.location.href = '/cover/template.html?page=poc';
				}
			},
			401: function() {
				window.location.href = '/cover/template.html?page=poc';
			}
		},
		error: function() {
			window.location.href = '/cover/template.html?page=poc';
		}
	});
}

////////////////////////////////////////////////////////////////////////////////////////
// --- select2 (사용자 자동완성 검색 ) 설정 --- //
////////////////////////////////////////////////////////////////////////////////////////
function select2_setting() {
	$(".js-data-example-ajax").select2({
		theme: "bootstrap",
		width: "100%",
		ajax: {
			url: function (params) {
				return "/auth-user/search-user/" + params.term;
			},
			dataType: "json",
			delay: 250,
			processResults: function (data, params) {
				params.page = params.page || 1;

				return {
					results: data,
					pagination: {
						more: params.page * 30 < data.total_count
					}
				};
			},
			cache: true
		},
		placeholder: "담당자를 검색하세요",
		allowClear: true,
		minimumInputLength: 1,
		templateResult: formatUser,
		templateSelection: formatUserSelection
	});
}

////////////////////////////////////////////////////////////////////¸////////////////////
// --- select2 (사용자 자동완성 검색 ) templateResult 설정 --- //
////////////////////////////////////////////////////////////////////////////////////////
function formatUser(jsonData) {
	if (jsonData.loading) {
		return jsonData.text;
	}

	var $container = $(
		"<div class='select2-result-jsonData clearfix'>" +
		"<div class='select2-result-jsonData__meta'>" +
		"<div class='select2-result-jsonData__username'><i class='fa fa-user'></i> </div>" +
		"<div class='select2-result-jsonData__id'><i class='fa fa-id-card'></i> </div>" +
		"</div>" +
		"</div>"
	);

	$container.find(".select2-result-jsonData__username").append(jsonData.username || '');
	$container.find(".select2-result-jsonData__id").append(jsonData.id || '');

	return $container;
}

////////////////////////////////////////////////////////////////////////////////////////
// --- select2 (사용자 자동완성 검색 ) templateSelection 설정 --- //
////////////////////////////////////////////////////////////////////////////////////////
function formatUserSelection(jsonData) {
	if (jsonData.id == "" || !jsonData.id) {
		return "담당자를 검색하세요";
	} else {
		if (jsonData.username == undefined) {
			return jsonData.id;
		} else {
			return "[" + jsonData.username + "] - " + jsonData.id;
		}
	}
}
