/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.sample;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.reader.tika.TikaDocumentReader;
import org.springframework.ai.transformer.splitter.TokenTextSplitter;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class MyPagePdfDocumentReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyPagePdfDocumentReader.class);
    private final ResourceLoader resourceLoader;
    private final VectorStore vectorStore;

    List<Document> getDocsFromPdf() {
        log.info("start getDocsFromPdf");
        Resource resource = this.resourceLoader.getResource("classpath:pmbokpdf/PMBOK_4th_Edition.pdf");
        try {
            byte[] data = resource.getInputStream().readAllBytes();
            ByteArrayResource newResource = new ByteArrayResource(this, data){

                public String getFilename() {
                    return "PMBOK_4th_Edition_\u1112\u1161\u11ab\u1100\u1173\u11af\u1111\u1161\u11ab_UNLOCK.pdf";
                }
            };
            TikaDocumentReader pdfReader = new TikaDocumentReader(resource);
            TokenTextSplitter tokenTextSplitter = new TokenTextSplitter();
            this.vectorStore.write(tokenTextSplitter.split(pdfReader.read()));
            log.info("end getDocsFromPdf");
            return pdfReader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public MyPagePdfDocumentReader(ResourceLoader resourceLoader, VectorStore vectorStore) {
        this.resourceLoader = resourceLoader;
        this.vectorStore = vectorStore;
    }
}

