/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.service;

import com.arms.api.wiki.model.WikiDTO;
import com.arms.api.wiki.model.WikiEntity;
import com.arms.api.wiki.model.WikiVO;
import com.arms.api.wiki.model.WikiVersionVO;
import com.arms.api.wiki.model.WikiVersionsVO;
import com.arms.api.wiki.service.WikiService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WikiServiceImpl
implements WikiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WikiServiceImpl.class);
    private final EsCommonRepositoryWrapper<WikiEntity> esCommonRepositoryWrapper;

    @Override
    public WikiVO getWiki(String wikiId) {
        WikiEntity docs = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiId));
        return WikiConverter.toVO(docs);
    }

    @Override
    public WikiVO getWiki(String wikiId, Long version) {
        WikiEntity docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("wiki_id", wikiId).andTermQueryFilter("version", version)).findFirst();
        return WikiConverter.toVO(docs);
    }

    @Override
    public WikiVersionsVO getWikiVersions(String wikiId, int size, int page) {
        WikiDTO wikiDTO = new WikiDTO();
        wikiDTO.setSize(size);
        wikiDTO.setPage(page);
        wikiDTO.setFieldIncludes(new String[]{"wiki_id", "version", "author", "recent", "created_date", "updated_date"});
        DocumentResultWrapper<WikiEntity> wiki = this.esCommonRepositoryWrapper.findHits(SimpleQuery.search(wikiDTO).andTermQueryFilter("wiki_id", wikiId).orderBy(SortDTO.builder().field("updated_date").sortType("desc").build()));
        Long totalHits = wiki.getTotalHits();
        List<WikiEntity> docs = wiki.toDocs();
        ArrayList<WikiVersionVO> wikiVersions = new ArrayList<WikiVersionVO>();
        for (WikiEntity wikiEntity : docs) {
            wikiVersions.add(WikiVersionVO.builder().wikiId(wikiEntity.getWikiId()).version(wikiEntity.getVersion()).author(wikiEntity.getAuthor()).recent(wikiEntity.isRecent()).createdDate(wikiEntity.getCreatedDate()).updatedDate(wikiEntity.getUpdatedDate()).build());
        }
        return WikiVersionsVO.builder().totalHits(totalHits).wikiVersions(wikiVersions).build();
    }

    @Override
    public String createWiki(WikiDTO wikiDTO) {
        WikiEntity savedEntity = this.esCommonRepositoryWrapper.save(wikiDTO.createEntity());
        return savedEntity.generateIdWithVersion();
    }

    @Override
    public String updateWiki(WikiDTO wikiDTO) {
        WikiEntity fetchedWiki = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiDTO.getWikiId()));
        if (fetchedWiki == null) {
            throw new IllegalArgumentException("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Wiki \ubb38\uc11c");
        }
        fetchedWiki.updateWikiEntity(wikiDTO.createEntityWithVersionUp(fetchedWiki.getVersion()));
        WikiEntity savedEntity = this.esCommonRepositoryWrapper.save(fetchedWiki);
        return savedEntity.generateIdWithVersion();
    }

    @Override
    public void changeRecent(WikiDTO wikiDTO) {
        DocumentResultWrapper<WikiEntity> currentRecent = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter("wiki_id", wikiDTO.getWikiId()));
        currentRecent.toHitDocs().forEach(a -> {
            String index = a.getIndex();
            WikiEntity content = (WikiEntity)a.getContent();
            content.setRecent(false);
            this.esCommonRepositoryWrapper.modifyWithIndexName(content, index);
        });
        DocumentResultWrapper<WikiEntity> wiki = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("wiki_id", wikiDTO.getWikiId()).andTermQueryFilter("version", wikiDTO.getVersion()));
        wiki.toHitDocs().forEach(a -> {
            String index = a.getIndex();
            WikiEntity content = (WikiEntity)a.getContent();
            content.setRecent(true);
            this.esCommonRepositoryWrapper.modifyWithIndexName(content, index);
        });
    }

    @Override
    public String deleteWiki(String wikiId) {
        WikiEntity wikiEntity = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiId));
        if (wikiEntity == null) {
            throw new IllegalArgumentException("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uc704\ud0a4 \ubb38\uc11c");
        }
        List<WikiEntity> docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryMust("wikiId", wikiId)).toDocs();
        for (WikiEntity doc : docs) {
            this.esCommonRepositoryWrapper.deleteById(doc.getId());
        }
        return wikiId;
    }

    @Generated
    public WikiServiceImpl(EsCommonRepositoryWrapper<WikiEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }

    class WikiConverter {
        WikiConverter(WikiServiceImpl this$0) {
        }

        public static WikiVO toVO(WikiEntity entity) {
            if (entity == null) {
                return null;
            }
            return WikiVO.builder().id(entity.getId()).contents(entity.getContents()).wikiId(entity.getWikiId()).author(entity.getAuthor()).version(entity.getVersion()).pdServiceId(entity.getPdServiceId()).createdDate(entity.getCreatedDate()).updatedDate(entity.getUpdatedDate()).build();
        }

        public static WikiVO emptyVO(String id) {
            return WikiVO.builder().id(id).contents("Empty - Document :: id \u2192 " + id).version(0L).diagramXmls(Collections.emptyList()).pdServiceId("").author("").build();
        }
    }
}

