/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.errors.response;

import com.arms.api.util.errors.response.ErrorCode;
import com.arms.api.util.response.CommonResponse;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ErrorControllerAdvice {
    private final SlackNotificationService slackNotificationService;

    private <E> ResponseEntity<CommonResponse.ApiResult<E>> newResponse(String message, ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity((Object)CommonResponse.error((String)message, (ErrorCode)errorCode, (HttpStatus)status), (MultiValueMap)headers, status);
    }

    private <E> ResponseEntity<CommonResponse.ApiResult<E>> newResponse(ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity((Object)CommonResponse.error((ErrorCode)errorCode, (HttpStatus)status), (MultiValueMap)headers, status);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        return headers;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public <E> ResponseEntity<CommonResponse.ApiResult<E>> handleArgumentException(IllegalArgumentException e) {
        return this.newResponse(e.getMessage(), ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public <E> ResponseEntity<CommonResponse.ApiResult<E>> handleAllException(Exception e) {
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.globalconfig, e);
        return this.newResponse(e.getMessage(), ErrorCode.COMMON_SYSTEM_ERROR, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ErrorControllerAdvice(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

