var ResourceApi = (function () {
    var selectedPdserviceId;
    var selectedPdServiceversions = [];

    var fetchedResourceData = [];
    var fetchedAssigneeInfo;

    var reqAssignees = [];
    var notReqAssignees = [];
    var customAssignees = [];

    var horizontalBarParamMap = {
        "properties" : ["priority", "status", "type"],
        "priority" : {
            "subGroupField" : "priority.priority_name.keyword",
            "target-req": "req-priority-bar",
            "target-notReq": "subtask-priority-bar"
        },
        "status": {
            "subGroupField" : "status.status_name.keyword",
            "target-req": "req-status-bar",
            "target-notReq": "subtask-status-bar"
        },
        "type": {
            "subGroupField" : "issuetype.issuetype_name.keyword",
            "target-req": "req-issuetype-bar",
            "target-notReq": "subtask-issuetype-bar"
        }
    }

    var getHorizontalBarParamMap = function () {
        return horizontalBarParamMap;
    }

    var pushReqAssignee = function (reqAssignee) { reqAssignees.push(reqAssignee); };

    var setReqAssignees = function (reqAssigneesData) { reqAssignees = reqAssigneesData};
    var getReqAssignees = function () { return reqAssignees; };
    var pushNotReqAssignee = function (notReqAssignee) { notReqAssignees.push(notReqAssignee); };

    var setNotReqAssignees = function (notReqAssigneesData) { notReqAssignees = notReqAssigneesData; };

    var getNotReqAssignees = function () { return notReqAssignees; };

    var pushCustomAssignee = function (customAssignee) { customAssignees.push(customAssignee); };

    var removeCustomAssignee = function (customAssignee) {
        if (!customAssignee || !customAssignee.uniqueId) {
            console.log("Invalid Assignee object");
            return;
        }

        const uniqueId = customAssignee.uniqueId;
        const index = customAssignees.findIndex(
            item => item.uniqueId === uniqueId
        );

        if (index !== -1) {
            customAssignees.splice(index, 1); // 해당 인덱스에서 제거
            console.log(`Removed Assignee with uniqueId: ${uniqueId}`);
        } else {
            console.log(`Assignee with uniqueId ${uniqueId} not found in the list`);
        }
    };

    var getCustomAssignees = function () { return customAssignees; };
		var getCustomBtoaAccounts = function () {
			let btoaAccounts = [];
			customAssignees.forEach((e) => {
				console.log(e);
				btoaAccounts.push(btoa(e.accountId))});
			return btoaAccounts;
		};
    var getCustomAssigneesExceptUniqueId = function () {
        return customAssignees.map(({ uniqueId, ...rest }) => rest);
    };
    var setPdServiceId = function (pdServiceId) { selectedPdserviceId = pdServiceId; };
    var getPdServiceId = function () { return selectedPdserviceId; };

    var setPdServiceVersionLinks = function (pdServiceVersionLinks) {
        selectedPdServiceversions = pdServiceVersionLinks; };
    var getPdServiceVersions = function () { return selectedPdServiceversions; };

    var fetchResourceData = function (pdservice_id, pdServiceVersionLinks) {
        var deferred = $.Deferred();
        setPdServiceId(pdservice_id);
        setPdServiceVersionLinks(pdServiceVersionLinks);

        $.ajax({
            url: "/auth-admin/api/arms/analysis/resource/issue-status-by-assignee",
            type: "GET",
            data: {
                "pdServiceAndIsReq.pdServiceLink" : selectedPdServiceId,
                "pdServiceAndIsReq.pdServiceVersionLinks" : selectedVersionId
            },
            contentType: "application/json;charset=UTF-8",
            dataType: "json",
            progress: true,
            async: false,
            statusCode: {
                200: function (data) {
                    fetchedResourceData = data;
                    deferred.resolve(data);
                },
                error: function (e) {
                    jError("Resource WorkerStatus 조회에 실패했습니다. 나중에 다시 시도 바랍니다.");
                }
            }
        });
        return deferred.promise();
    };
    var getFetchedResourceData = function () {
        return fetchedResourceData;
    };

    var fetchAssigneeInfoMap = function (pdservice_id, pdServiceVersionLinks) {
        var deferred = $.Deferred();

        let $url = "/auth-admin/api/arms/analysis/resource/assignees-info";
        $.ajax({
            url: $url,
            type: "GET",
            data: {
                "pdServiceAndIsReq.pdServiceLink" : selectedPdServiceId,
                "pdServiceAndIsReq.pdServiceVersionLinks" : selectedVersionId
            },
            contentType: "application/json;charset=UTF-8",
            dataType: "json",
            progress: true,
            async: false,
            statusCode: {
                200: function (data) {
                    fetchedAssigneeInfo = data;
                    deferred.resolve(fetchedAssigneeInfo);
                },
                error: function (e) {
                    jError("Resource AssigneeInfoMap 조회에 실패했습니다. 나중에 다시 시도 바랍니다.");
                }
            }
        });

        return deferred.promise();
    };

    var getFetchedAssigneeInfoMap = function() {
        return fetchedAssigneeInfo;
    }

    return {
        setPdServiceId, getPdServiceId,
        setPdServiceVersionLinks, getPdServiceVersions,

        fetchResourceData, getFetchedResourceData,
        fetchAssigneeInfoMap, getFetchedAssigneeInfoMap,

        pushReqAssignee, setReqAssignees, getReqAssignees,
        pushNotReqAssignee, setNotReqAssignees, getNotReqAssignees,
        pushCustomAssignee, removeCustomAssignee, getCustomAssignees,

        getHorizontalBarParamMap, getCustomAssigneesExceptUniqueId, getCustomBtoaAccounts
    }
})();