package com.arms.api.issue.almapi.model.vo.cloudjiraspec;


import com.arms.api.issue.almapi.model.vo.IssueFieldData;
import lombok.*;

@Getter
@EqualsAndHashCode(of = {"id","key"})
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CloudJiraIssueRawDataVO {

    private String id;

    private String key;

    private String self;

    private IssueFieldData fields;

    private ChangeLogVO changelog;

    private String rawData;

    public void applyRawData(String rawData){
        this.rawData = rawData;
    }

    public String getParentKey() {
        if(fields.getParent() != null){
            return fields.getParent().getKey();
        }else{
            return null;
        }
    }



}
