package com.arms.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class ElasticsearchIndexNameConfig {

	@Value("${arms-index-name.jiraissue}")
	private String jiraissue;

	@Bean
	public String jiraissue(){
		return jiraissue;
	}

	@Value("${arms-index-name.serverinfo}")
	private String serverinfo;

	@Bean
	public String serverinfo(){
		return serverinfo;
	}

	@Value("${arms-index-name.fluentd}")
	private String fluentd;

	@Bean
	public String fluentd(){
		return fluentd;
	}
}
