/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import com.arms.api.schedule.model.vo.ScheduleInfoVO;
import com.arms.api.schedule.model.vo.ScheduleMapVO;
import com.arms.api.schedule.service.ScheduleService;
import com.arms.api.schedule.util.ScheduleMapProvider;
import com.arms.api.schedule.util.ScheduleTaskDispatcher;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@EnableScheduling
public class DynamicSchedulerConfig
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DynamicSchedulerConfig.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private ScheduleTaskDispatcher dispatcher;
    private ScheduledTaskRegistrar taskRegistrar;
    private final List<ScheduledTask> scheduledTasks = new CopyOnWriteArrayList();
    private final ScheduleMapProvider scheduleMapProvider;

    public DynamicSchedulerConfig(ScheduleMapProvider scheduleMapProvider) {
        log.info("DynamicSchedulerConfig initialized.");
        this.scheduleMapProvider = scheduleMapProvider;
    }

    @Bean(name={"dynamicTaskScheduler"})
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(10);
        scheduler.setThreadNamePrefix("Dynamic-scheduler-");
        scheduler.initialize();
        return scheduler;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        log.info("DynamicSchedulerConfig :: configureTasks");
        this.taskRegistrar = taskRegistrar;
        taskRegistrar.setTaskScheduler(this.taskScheduler());
    }

    private void scheduleTasks() {
        for (ScheduledTask task : this.scheduledTasks) {
            task.cancel();
        }
        this.scheduledTasks.clear();
        ScheduleMapVO scheduleMapVO = this.scheduleMapProvider.getScheduleMapVO();
        if (scheduleMapVO == null) {
            log.warn("[DynamicSchedulerConfig :: scheduleTasks] :: scheduleMapVO is null.");
            return;
        }
        Map scheduleInfoMap = scheduleMapVO.getScheduleInfoMap();
        if (scheduleInfoMap == null || scheduleInfoMap.isEmpty()) {
            log.warn("[DynamicSchedulerConfig :: scheduleTasks] :: No schedule info found in scheduleInfoMap.");
            return;
        }
        scheduleInfoMap.forEach((fileName, scheduleList) -> {
            for (ScheduleInfoVO scheduleInfo : scheduleList) {
                Runnable task;
                if (!Boolean.TRUE.equals(scheduleInfo.getEnabled())) continue;
                String name = scheduleInfo.getName();
                String methodName = scheduleInfo.getName();
                String cron = scheduleInfo.getCron();
                String notes = scheduleInfo.getNotes();
                Runnable businessLogic = null;
                if (this.dispatcher.contains(name)) {
                    log.info("businessLogic is fetched by scheduleName [{}]", (Object)name);
                    businessLogic = this.dispatcher.getTask(name);
                } else if (this.dispatcher.contains(methodName)) {
                    log.info("businessLogic is fetched by methodName [{}]", (Object)methodName);
                    businessLogic = this.dispatcher.getTask(methodName);
                }
                if (businessLogic != null) {
                    Runnable fetchedLogic = businessLogic;
                    task = () -> {
                        log.info("Executing [{}] from [{}] - {}", new Object[]{name, fileName, notes});
                        long start = System.nanoTime();
                        try {
                            fetchedLogic.run();
                        }
                        catch (Exception e) {
                            try {
                                log.error("Error during execution of [{}]: {}", new Object[]{name, e.getMessage(), e});
                            }
                            catch (Throwable throwable) {
                                long end = System.nanoTime();
                                long elapsedMs = TimeUnit.NANOSECONDS.toMillis(end - start);
                                log.info("Finished [{}] from [{}] in {} ms", new Object[]{name, fileName, elapsedMs});
                                throw throwable;
                            }
                            long end = System.nanoTime();
                            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(end - start);
                            log.info("Finished [{}] from [{}] in {} ms", new Object[]{name, fileName, elapsedMs});
                        }
                        long end = System.nanoTime();
                        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(end - start);
                        log.info("Finished [{}] from [{}] in {} ms", new Object[]{name, fileName, elapsedMs});
                    };
                } else {
                    task = () -> log.info("Executing [{}] from [{}] - {} (No business logic mapped)", new Object[]{name, fileName, notes});
                }
                CronTask cronTask = new CronTask(task, cron);
                ScheduledTask scheduledTask = this.taskRegistrar.scheduleCronTask(cronTask);
                this.scheduledTasks.add(scheduledTask);
                log.info("Registered [{}] from [{}] with cron [{}]", new Object[]{name, fileName, cron});
            }
        });
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    public void onRefresh() throws Exception {
        log.info("[DynamicSchedulerConfig :: onRefresh] :: Refreshing dynamic schedules...");
        ScheduleMapVO refreshedMap = this.scheduleService.getScheduleList();
        this.scheduleMapProvider.setScheduleMapVO(refreshedMap);
        this.scheduleTasks();
        log.info("[DynamicSchedulerConfig :: onRefresh] :: Schedules refreshed successfully.");
    }

    public void refreshSchedules() throws Exception {
        log.info("[DynamicSchedulerConfig :: refreshSchedules] :: Manually triggering schedule refresh...");
        ScheduleMapVO refreshedMap = this.scheduleService.getScheduleList();
        this.scheduleMapProvider.setScheduleMapVO(refreshedMap);
        this.scheduleTasks();
        log.info("[DynamicSchedulerConfig :: refreshSchedules] :: Manual refresh complete.");
    }
}

