package com.arms.api.languageconfig.service;

import com.arms.api.languageconfig.model.vo.LanguagePackFileVO;
import com.arms.api.languageconfig.model.vo.SingleLanguagePackVO;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface LanguageConfigService {
    List<LanguagePackFileVO> getLanguagePackFiles(RepoType repoType);
    List<LanguagePackFileVO> getLanguagePackFiles_old();

    List<SingleLanguagePackVO> getAllLanguagePackContents();
    SingleLanguagePackVO getSingleLanguagePack(String language);
    SingleLanguagePackVO refreshSingleLanguagePack(String language);

    String updateSingleLanguagePack(String language, Map<String, String> languagePack) throws IOException;
    String deleteSingleLanguagePack(String language);

    List<SingleLanguagePackVO> refreshAllLanguagePackContents();

    List<String> checkLanguageKeyExists(String language, List<String> keys);
}
