/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.slack;

import com.arms.api.util.slack.SlackMessageDTO;
import com.arms.api.util.slack.SlackProperty;
import com.slack.api.Slack;
import com.slack.api.model.Attachment;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SlackNotificationService {
    private static final Logger log = LoggerFactory.getLogger(SlackNotificationService.class);
    private final SlackProperty slackProperty;
    private final Environment environment;

    public void sendMessageToChannel(SlackProperty.Channel channel, Exception e) {
        if (this.isStage()) {
            String title = MessageFormat.format("[{0}] {1}", this.slackProperty.getProfile(), this.slackProperty.getServiceName());
            String text = this.messageInStackTrace(e);
            SlackMessageDTO slackMessageDTO = SlackMessageDTO.builder().title(title).text(text).build();
            List<Attachment> attachments = List.of(slackMessageDTO.parseAttachment());
            Slack slack = Slack.getInstance();
            try {
                slack.methods(this.slackProperty.getToken()).chatPostMessage(request -> request.channel(channel.name()).attachments(attachments));
            }
            catch (Exception exception) {
                log.error("Failed to send Slack message: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    public void sendMessageToChannel(SlackProperty.Channel channel, String message) {
        if (this.isStage()) {
            String title = MessageFormat.format("[{0}] {1}", this.slackProperty.getProfile(), this.slackProperty.getServiceName());
            SlackMessageDTO slackMessageDTO = SlackMessageDTO.builder().title(title).text(message).build();
            List<Attachment> attachments = List.of(slackMessageDTO.parseAttachment());
            Slack slack = Slack.getInstance();
            try {
                slack.methods(this.slackProperty.getToken()).chatPostMessage(request -> request.channel(channel.name()).attachments(attachments));
            }
            catch (Exception exception) {
                log.error("Failed to send Slack message: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    private String messageInStackTrace(Exception e) {
        String filteredStackTrace = Arrays.stream(e.getStackTrace()).filter(stackTraceElement -> stackTraceElement.getClassName().contains("com.arms")).map(StackTraceElement::toString).collect(Collectors.joining("\n", "\n\n[StackTrace]\n", ""));
        return String.valueOf(e) + (filteredStackTrace.isBlank() ? "" : filteredStackTrace);
    }

    private boolean isStage() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("stg");
    }

    public SlackNotificationService(SlackProperty slackProperty, Environment environment) {
        this.slackProperty = slackProperty;
        this.environment = environment;
    }
}

