/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.errors.response;

import com.arms.api.util.errors.response.ErrorCode;
import com.arms.api.util.response.CommonResponse;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@ControllerAdvice
public class ErrorControllerAdvice {
    private final SlackNotificationService slackNotificationService;

    @ExceptionHandler(value={ClientAuthorizationException.class})
    public Mono<?> onException() {
        return Mono.error((Throwable)new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Session is null"));
    }

    private <E> ResponseEntity<CommonResponse.ApiResult<E>> newResponse(String message, ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity(CommonResponse.error(message, errorCode, status), (MultiValueMap)headers, status);
    }

    private <E> ResponseEntity<CommonResponse.ApiResult<E>> newResponse(ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity(CommonResponse.error(errorCode, status), (MultiValueMap)headers, status);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        return headers;
    }

    @ExceptionHandler(value={WebExchangeBindException.class})
    public <E> ResponseEntity<CommonResponse.ApiResult<E>> handleException(WebExchangeBindException e) {
        BindingResult bindingResult = e.getBindingResult();
        FieldError fe = bindingResult.getFieldError();
        if (fe != null) {
            String message = fe.getDefaultMessage();
            return this.newResponse(message, ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
        }
        return this.newResponse(ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public <E> ResponseEntity<CommonResponse.ApiResult<E>> handleArgumentException(IllegalArgumentException e) {
        return this.newResponse(e.getMessage(), ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public <E> ResponseEntity<CommonResponse.ApiResult<E>> handleAllException(Exception e) {
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.middleproxy, e);
        return this.newResponse(e.getMessage(), ErrorCode.COMMON_SYSTEM_ERROR, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ErrorControllerAdvice(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

