/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.keycloak.admin.controller;

import com.arms.api.keycloak.admin.model.CreateUserVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.token.TokenManager;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
public class KeycloakAdminController {
    private static final Logger log = LoggerFactory.getLogger(KeycloakAdminController.class);
    private final Keycloak keycloak;

    @GetMapping(value={"/auth-admin/token"})
    @ResponseBody
    public Mono<TokenManager> getAuthToken(ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.tokenManager());
    }

    @GetMapping(value={"/auth-admin/realms/"})
    @ResponseBody
    public Mono<List<RealmRepresentation>> getRealms(ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.realms().findAll());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}"})
    @ResponseBody
    public Mono<RealmRepresentation> getRealms(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        return Mono.just((Object)this.keycloak.realm(realm).toRepresentation());
    }

    @PutMapping(value={"/auth-admin/realms/{realm}"})
    @ResponseBody
    public Mono<Void> updateRealm(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @RequestBody RealmRepresentation realmRepresentation) {
        this.keycloak.realm(realm).update(realmRepresentation);
        return Mono.empty();
    }

    @PostMapping(value={"/auth-admin/realms/{realm}"})
    @ResponseBody
    public Mono<Void> testSMTPConnection(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @RequestBody RealmRepresentation realmRepresentation) {
        this.keycloak.realm(realm).testSMTPConnection(realmRepresentation.getSmtpServer());
        return Mono.empty();
    }

    @PostMapping(value={"/auth-admin/realms/smtp/{realm}"})
    @ResponseBody
    public Mono<Void> configureSmtp(ServerWebExchange exchange, @PathVariable(value="realm") String realmName) {
        try {
            RealmRepresentation realm = this.keycloak.realm(realmName).toRepresentation();
            HashMap<String, String> smtpConfig = new HashMap<String, String>();
            smtpConfig.put("host", "smtp.smtp.net");
            smtpConfig.put("port", "465");
            smtpConfig.put("from", "mail@a-rms.net");
            smtpConfig.put("auth", "true");
            smtpConfig.put("ssl", "true");
            smtpConfig.put("user", "mail@a-rms.net");
            smtpConfig.put("password", "");
            smtpConfig.put("starttls", "true");
            smtpConfig.put("replyToDisplayName", "[ A-RMS ]");
            smtpConfig.put("replyTo", "mail@a-rms.net");
            smtpConfig.put("envelopeFrom", "mail@a-rms.net");
            smtpConfig.put("fromDisplayName", "[ A-RMS ]");
            realm.setSmtpServer(smtpConfig);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            String realmJson = mapper.writeValueAsString((Object)realm);
            log.info("Realm \uc804\uccb4 \uc124\uc815 \uc815\ubcf4:\n{}", (Object)realmJson);
            smtpConfig.forEach((key, value) -> log.info("smtpServer \uc124\uc815 - {} = {}", key, value));
            this.keycloak.realm(realmName).update(realm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Mono.empty();
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/clients"})
    @ResponseBody
    public Mono<List<ClientRepresentation>> getClients(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        return Mono.just((Object)this.keycloak.realm(realm).clients().findAll());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/client-id/{clientId}"})
    @ResponseBody
    public Mono<List<ClientRepresentation>> getClient(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="clientId") String clientId) {
        return Mono.just((Object)this.keycloak.realm(realm).clients().findByClientId(clientId));
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups"})
    @ResponseBody
    public Mono<List<GroupRepresentation>> getGroups(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().groups());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}"})
    @ResponseBody
    public Mono<GroupRepresentation> getGroup(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().group(groupId).toRepresentation());
    }

    @PutMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}"})
    @ResponseBody
    public void editGroup(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, @RequestBody GroupRepresentation groupRepresentation) {
        this.keycloak.realm(realm).groups().group(groupId).update(groupRepresentation);
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}"})
    public void deleteGroup(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId) {
        this.keycloak.realm(realm).groups().group(groupId).remove();
    }

    @PostMapping(value={"/auth-admin/realms/{realms}/groups"})
    public void createGroup(ServerWebExchange exchange, @PathVariable(value="realms") String realm, @RequestBody GroupRepresentation groupRepresentation) {
        this.keycloak.realm(realm).groups().add(groupRepresentation);
    }

    @PostMapping(value={"/auth-admin/realms/{realms}/groups/{group-id}/children"})
    public void createChildGroup(ServerWebExchange exchange, @PathVariable(value="realms") String realm, @PathVariable(value="group-id") String groupId, @RequestBody GroupRepresentation groupRepresentation) {
        this.keycloak.realm(realm).groups().group(groupId).subGroup(groupRepresentation);
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/role-mappings/realm/composite"})
    @ResponseBody
    public Mono<List<RoleRepresentation>> getComposite(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().group(groupId).roles().realmLevel().listEffective());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/role-mappings/realm/available"})
    @ResponseBody
    public Mono<List<RoleRepresentation>> getAvailableRoles(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().group(groupId).roles().realmLevel().listAvailable());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/role-mappings/realm"})
    @ResponseBody
    public Mono<List<RoleRepresentation>> getAssignedRoles(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().group(groupId).roles().realmLevel().listAll());
    }

    @PostMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/role-mappings/realm"})
    public void addGroupRoles(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, @RequestBody List<RoleRepresentation> roleRepresentations, ServerWebExchange exchange) {
        this.keycloak.realm(realm).groups().group(groupId).roles().realmLevel().add(roleRepresentations);
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/role-mappings/realm"})
    public void deleteGroupRoles(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, @RequestBody List<RoleRepresentation> roleRepresentations, ServerWebExchange exchange) {
        this.keycloak.realm(realm).groups().group(groupId).roles().realmLevel().remove(roleRepresentations);
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/groups/{group-id}/members"})
    @ResponseBody
    public Mono<List<UserRepresentation>> getGroupMembers(@PathVariable(value="realm") String realm, @PathVariable(value="group-id") String groupId, ServerWebExchange exchange) {
        return Mono.just((Object)this.keycloak.realm(realm).groups().group(groupId).members());
    }

    @PostMapping(value={"/auth-admin/realms/{realm}/role"})
    public void createRole(@PathVariable(value="realm") String realm, @RequestBody RoleRepresentation roleRepresentation) {
        this.keycloak.realm(realm).roles().create(roleRepresentation);
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/roles"})
    @ResponseBody
    public Mono<List<RoleRepresentation>> getRoles(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        return Mono.just((Object)this.keycloak.realm(realm).roles().list(false));
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/role/{role}"})
    @ResponseBody
    public Mono<RoleRepresentation> getRole(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="role") String role) {
        return Mono.just((Object)this.keycloak.realm(realm).roles().get(role).toRepresentation());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/role/{role}/users"})
    @ResponseBody
    public Mono<Set<UserRepresentation>> getUsersInRole(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="role") String role) {
        return Mono.just((Object)this.keycloak.realm(realm).roles().get(role).getRoleUserMembers());
    }

    @PutMapping(value={"/auth-admin/realms/{realm}/role/{role}"})
    public void updateRole(@PathVariable(value="realm") String realm, @PathVariable(value="role") String role, @RequestBody RoleRepresentation roleRepresentation) {
        this.keycloak.realm(realm).roles().get(role).update(roleRepresentation);
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/role/{role}"})
    public void removeRole(@PathVariable(value="realm") String realm, @PathVariable(value="role") String role) {
        this.keycloak.realm(realm).roles().get(role).remove();
    }

    @PostMapping(value={"/auth-admin/realms/{realm}/user"})
    @ResponseBody
    public Mono<Void> createUser(@PathVariable(value="realm") String realm, @RequestBody CreateUserVO createUserVO) {
        UserRepresentation userRepresentation = createUserVO.getUserRepresentation();
        CredentialRepresentation credentialRepresentation = createUserVO.getCredentialRepresentation();
        List<RoleRepresentation> roleRepresentation = Collections.singletonList(this.keycloak.realm(realm).roles().get("ROLE_USER").toRepresentation());
        userRepresentation.setEnabled(Boolean.valueOf(true));
        try (Response newUser = this.keycloak.realm(realm).users().create(userRepresentation);){
            String userId = newUser.getLocation().getPath().replaceAll(".*/([^/]+)$", "$1");
            this.resetPassword(realm, userId, credentialRepresentation);
            this.addMappingRoles(realm, userId, roleRepresentation);
        }
        return Mono.empty();
    }

    @PutMapping(value={"/auth-admin/realms/{realm}/user/{user}/reset-password"})
    public Mono<Void> resetPassword(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @RequestBody CredentialRepresentation credentialRepresentation) {
        credentialRepresentation.setType("password");
        this.keycloak.realm(realm).users().get(user).resetPassword(credentialRepresentation);
        return Mono.empty();
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/users"})
    @ResponseBody
    public Mono<List<UserRepresentation>> getUsers(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        return Mono.just((Object)this.keycloak.realm(realm).users().list());
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/user/{user}"})
    @ResponseBody
    public Mono<UserRepresentation> getUser(ServerWebExchange exchange, @PathVariable(value="realm") String realm, @PathVariable(value="user") String user) {
        return Mono.just((Object)this.keycloak.realm(realm).users().get(user).toRepresentation());
    }

    @PutMapping(value={"/auth-admin/realms/{realm}/user/{user}"})
    public void updateUser(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @RequestBody UserRepresentation userRepresentation) {
        this.keycloak.realm(realm).users().get(user).update(userRepresentation);
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/user/{user}"})
    public void removeUser(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user) {
        this.keycloak.realm(realm).users().get(user).remove();
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/user/{user}/role-mappings/realm"})
    @ResponseBody
    public Mono<List<RoleRepresentation>> getRoleMappings(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user) {
        return Mono.just((Object)this.keycloak.realm(realm).users().get(user).roles().getAll().getRealmMappings());
    }

    @PostMapping(value={"/auth-admin/realms/{realm}/user/{user}/role-mappings/realm"})
    public Mono<Void> addMappingRoles(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @RequestBody List<RoleRepresentation> rolesToAdd) {
        this.keycloak.realm(realm).users().get(user).roles().realmLevel().add(rolesToAdd);
        return Mono.empty();
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/user/{user}/role-mappings/realm"})
    public Mono<Void> deleteMappingRoles(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @RequestBody List<RoleRepresentation> rolesToRemove) {
        this.keycloak.realm(realm).users().get(user).roles().realmLevel().remove(rolesToRemove);
        return Mono.empty();
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/user/{user}/groups"})
    public Mono<List<GroupRepresentation>> getGroupMappings(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user) {
        return Mono.just((Object)this.keycloak.realm(realm).users().get(user).groups());
    }

    @PutMapping(value={"/auth-admin/realms/{realm}/user/{user}/groups/{group-id}"})
    public Mono<Void> addMappingGroup(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @PathVariable(value="group-id") String groupId) {
        this.keycloak.realm(realm).users().get(user).joinGroup(groupId);
        return Mono.empty();
    }

    @DeleteMapping(value={"/auth-admin/realms/{realm}/user/{user}/groups/{group-id}"})
    public Mono<Void> deleteMappingGroup(@PathVariable(value="realm") String realm, @PathVariable(value="user") String user, @PathVariable(value="group-id") String groupId) {
        this.keycloak.realm(realm).users().get(user).leaveGroup(groupId);
        return Mono.empty();
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/access-control/users"})
    @ResponseBody
    public Mono<List<UserRepresentation>> getAccessControlUsers(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        List users = this.keycloak.realm(realm).users().list().stream().map(user -> this.keycloak.realm(realm).users().get(user.getId()).toRepresentation()).collect(Collectors.toList());
        return Mono.just((Object)this.keycloak.realm(realm).users().list());
    }

    public List<GroupRepresentation> getFlattenGroup(List<GroupRepresentation> groupRepresentationList, GroupRepresentation group) {
        groupRepresentationList.add(group);
        if (group.getSubGroups() != null && !group.getSubGroups().isEmpty()) {
            group.getSubGroups().forEach(subGroup -> this.getFlattenGroup(groupRepresentationList, subGroup));
        }
        return groupRepresentationList;
    }

    @GetMapping(value={"/auth-admin/realms/{realm}/access-control/groups"})
    @ResponseBody
    public Mono<List<GroupRepresentation>> getAccessControlGroups(ServerWebExchange exchange, @PathVariable(value="realm") String realm) {
        ArrayList groups = new ArrayList();
        this.keycloak.realm(realm).groups().groups().forEach(tempGroup -> {
            GroupRepresentation group = this.keycloak.realm(realm).groups().group(tempGroup.getId()).toRepresentation();
            this.getFlattenGroup(groups, group);
        });
        return Mono.just(groups);
    }

    public KeycloakAdminController(Keycloak keycloak) {
        this.keycloak = keycloak;
    }
}

