/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Component
public class KeycloakLogoutHandler
implements ServerLogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(KeycloakLogoutHandler.class);
    private final WebClient webClient;
    private final String serverUrl;

    public KeycloakLogoutHandler(WebClient webClient, @Value(value="${spring.security.oauth2.client.registration.middle-proxy.server-url}") String serverUrl) {
        this.webClient = webClient;
        this.serverUrl = serverUrl;
    }

    public Mono<Void> logout(WebFilterExchange exchange, Authentication authentication) {
        OidcUser principal = (OidcUser)authentication.getPrincipal();
        return this.logoutFromKeycloak(principal.getIdToken().getTokenValue());
    }

    public Mono<Void> logoutFromKeycloak(String idToken) {
        String endSessionEndpoint = this.serverUrl + "/realms/master/protocol/openid-connect/logout";
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endSessionEndpoint).queryParam("id_token_hint", new Object[]{idToken});
        return this.webClient.get().uri(builder.toUriString(), new Object[0]).exchangeToMono(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                log.info("Successfully logged out from Keycloak");
                return Mono.empty();
            }
            log.error("Could not propagate logout to Keycloak");
            return Mono.error((Throwable)new RuntimeException("Could not propagate logout to Keycloak"));
        });
    }
}

