/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.fluentd.entity;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.RollingIndexName;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@fluentd}", createIndex=false)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_class")
@JsonTypeName(value="com.arms.api.fluentd.entity.FluentdEntity")
@JsonIgnoreProperties(ignoreUnknown=true)
@ElasticSearchTemplateConfig
public class FluentdEntity
implements BaseEntity {
    @Id
    @ReadOnlyProperty
    private String id;
    @Field(type=FieldType.Keyword, name="@log_name")
    private String logName;
    @Field(type=FieldType.Date, name="@timestamp", pattern={"uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSSZZZZZ"})
    private Date timestamp;
    @Field(type=FieldType.Text, name="log")
    private String log;
    @Field(type=FieldType.Text, name="chunk")
    private String chunk;
    @Field(type=FieldType.Text, name="chunk_id")
    private String chunk_id;
    @Field(type=FieldType.Keyword, name="container_id")
    private String container_id;
    @Field(type=FieldType.Keyword, name="container_name")
    private String container_name;
    @Field(type=FieldType.Text, name="error")
    private String error;
    @Field(type=FieldType.Text, name="message")
    private String message;
    @Field(type=FieldType.Text, name="partial_id")
    private String partial_id;
    @Field(type=FieldType.Text, name="partial_last")
    private String partial_last;
    @Field(type=FieldType.Text, name="partial_message")
    private String partial_message;
    @Field(type=FieldType.Text, name="partial_ordinal")
    private String partial_ordinal;
    @Field(type=FieldType.Text, name="retry_time")
    private String retry_time;
    @Field(type=FieldType.Keyword, name="source")
    private String source;

    @RollingIndexName
    public String indexName() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDateTime localDateTime = LocalDateTime.now(ZoneId.of("Asia/Seoul"));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of("Asia/Seoul"));
        return zonedDateTime.format(formatter);
    }

    @Generated
    public static FluentdEntityBuilder builder() {
        return new FluentdEntityBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FluentdEntity)) {
            return false;
        }
        FluentdEntity other = (FluentdEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$logName = this.getLogName();
        String other$logName = other.getLogName();
        if (this$logName == null ? other$logName != null : !this$logName.equals(other$logName)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$log = this.getLog();
        String other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        String this$chunk = this.getChunk();
        String other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        String this$chunk_id = this.getChunk_id();
        String other$chunk_id = other.getChunk_id();
        if (this$chunk_id == null ? other$chunk_id != null : !this$chunk_id.equals(other$chunk_id)) {
            return false;
        }
        String this$container_id = this.getContainer_id();
        String other$container_id = other.getContainer_id();
        if (this$container_id == null ? other$container_id != null : !this$container_id.equals(other$container_id)) {
            return false;
        }
        String this$container_name = this.getContainer_name();
        String other$container_name = other.getContainer_name();
        if (this$container_name == null ? other$container_name != null : !this$container_name.equals(other$container_name)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$partial_id = this.getPartial_id();
        String other$partial_id = other.getPartial_id();
        if (this$partial_id == null ? other$partial_id != null : !this$partial_id.equals(other$partial_id)) {
            return false;
        }
        String this$partial_last = this.getPartial_last();
        String other$partial_last = other.getPartial_last();
        if (this$partial_last == null ? other$partial_last != null : !this$partial_last.equals(other$partial_last)) {
            return false;
        }
        String this$partial_message = this.getPartial_message();
        String other$partial_message = other.getPartial_message();
        if (this$partial_message == null ? other$partial_message != null : !this$partial_message.equals(other$partial_message)) {
            return false;
        }
        String this$partial_ordinal = this.getPartial_ordinal();
        String other$partial_ordinal = other.getPartial_ordinal();
        if (this$partial_ordinal == null ? other$partial_ordinal != null : !this$partial_ordinal.equals(other$partial_ordinal)) {
            return false;
        }
        String this$retry_time = this.getRetry_time();
        String other$retry_time = other.getRetry_time();
        if (this$retry_time == null ? other$retry_time != null : !this$retry_time.equals(other$retry_time)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FluentdEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $logName = this.getLogName();
        result = result * 59 + ($logName == null ? 43 : $logName.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        String $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        String $chunk_id = this.getChunk_id();
        result = result * 59 + ($chunk_id == null ? 43 : $chunk_id.hashCode());
        String $container_id = this.getContainer_id();
        result = result * 59 + ($container_id == null ? 43 : $container_id.hashCode());
        String $container_name = this.getContainer_name();
        result = result * 59 + ($container_name == null ? 43 : $container_name.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $partial_id = this.getPartial_id();
        result = result * 59 + ($partial_id == null ? 43 : $partial_id.hashCode());
        String $partial_last = this.getPartial_last();
        result = result * 59 + ($partial_last == null ? 43 : $partial_last.hashCode());
        String $partial_message = this.getPartial_message();
        result = result * 59 + ($partial_message == null ? 43 : $partial_message.hashCode());
        String $partial_ordinal = this.getPartial_ordinal();
        result = result * 59 + ($partial_ordinal == null ? 43 : $partial_ordinal.hashCode());
        String $retry_time = this.getRetry_time();
        result = result * 59 + ($retry_time == null ? 43 : $retry_time.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FluentdEntity(id=" + this.getId() + ", logName=" + this.getLogName() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", log=" + this.getLog() + ", chunk=" + this.getChunk() + ", chunk_id=" + this.getChunk_id() + ", container_id=" + this.getContainer_id() + ", container_name=" + this.getContainer_name() + ", error=" + this.getError() + ", message=" + this.getMessage() + ", partial_id=" + this.getPartial_id() + ", partial_last=" + this.getPartial_last() + ", partial_message=" + this.getPartial_message() + ", partial_ordinal=" + this.getPartial_ordinal() + ", retry_time=" + this.getRetry_time() + ", source=" + this.getSource() + ")";
    }

    @Generated
    public FluentdEntity(String id, String logName, Date timestamp, String log, String chunk, String chunk_id, String container_id, String container_name, String error, String message, String partial_id, String partial_last, String partial_message, String partial_ordinal, String retry_time, String source) {
        this.id = id;
        this.logName = logName;
        this.timestamp = timestamp;
        this.log = log;
        this.chunk = chunk;
        this.chunk_id = chunk_id;
        this.container_id = container_id;
        this.container_name = container_name;
        this.error = error;
        this.message = message;
        this.partial_id = partial_id;
        this.partial_last = partial_last;
        this.partial_message = partial_message;
        this.partial_ordinal = partial_ordinal;
        this.retry_time = retry_time;
        this.source = source;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getLogName() {
        return this.logName;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getLog() {
        return this.log;
    }

    @Generated
    public String getChunk() {
        return this.chunk;
    }

    @Generated
    public String getChunk_id() {
        return this.chunk_id;
    }

    @Generated
    public String getContainer_id() {
        return this.container_id;
    }

    @Generated
    public String getContainer_name() {
        return this.container_name;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getPartial_id() {
        return this.partial_id;
    }

    @Generated
    public String getPartial_last() {
        return this.partial_last;
    }

    @Generated
    public String getPartial_message() {
        return this.partial_message;
    }

    @Generated
    public String getPartial_ordinal() {
        return this.partial_ordinal;
    }

    @Generated
    public String getRetry_time() {
        return this.retry_time;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLogName(String logName) {
        this.logName = logName;
    }

    @Generated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setLog(String log) {
        this.log = log;
    }

    @Generated
    public void setChunk(String chunk) {
        this.chunk = chunk;
    }

    @Generated
    public void setChunk_id(String chunk_id) {
        this.chunk_id = chunk_id;
    }

    @Generated
    public void setContainer_id(String container_id) {
        this.container_id = container_id;
    }

    @Generated
    public void setContainer_name(String container_name) {
        this.container_name = container_name;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setPartial_id(String partial_id) {
        this.partial_id = partial_id;
    }

    @Generated
    public void setPartial_last(String partial_last) {
        this.partial_last = partial_last;
    }

    @Generated
    public void setPartial_message(String partial_message) {
        this.partial_message = partial_message;
    }

    @Generated
    public void setPartial_ordinal(String partial_ordinal) {
        this.partial_ordinal = partial_ordinal;
    }

    @Generated
    public void setRetry_time(String retry_time) {
        this.retry_time = retry_time;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public FluentdEntity() {
    }

    @Generated
    public static class FluentdEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String logName;
        @Generated
        private Date timestamp;
        @Generated
        private String log;
        @Generated
        private String chunk;
        @Generated
        private String chunk_id;
        @Generated
        private String container_id;
        @Generated
        private String container_name;
        @Generated
        private String error;
        @Generated
        private String message;
        @Generated
        private String partial_id;
        @Generated
        private String partial_last;
        @Generated
        private String partial_message;
        @Generated
        private String partial_ordinal;
        @Generated
        private String retry_time;
        @Generated
        private String source;

        @Generated
        FluentdEntityBuilder() {
        }

        @Generated
        public FluentdEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public FluentdEntityBuilder logName(String logName) {
            this.logName = logName;
            return this;
        }

        @Generated
        public FluentdEntityBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public FluentdEntityBuilder log(String log) {
            this.log = log;
            return this;
        }

        @Generated
        public FluentdEntityBuilder chunk(String chunk) {
            this.chunk = chunk;
            return this;
        }

        @Generated
        public FluentdEntityBuilder chunk_id(String chunk_id) {
            this.chunk_id = chunk_id;
            return this;
        }

        @Generated
        public FluentdEntityBuilder container_id(String container_id) {
            this.container_id = container_id;
            return this;
        }

        @Generated
        public FluentdEntityBuilder container_name(String container_name) {
            this.container_name = container_name;
            return this;
        }

        @Generated
        public FluentdEntityBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public FluentdEntityBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public FluentdEntityBuilder partial_id(String partial_id) {
            this.partial_id = partial_id;
            return this;
        }

        @Generated
        public FluentdEntityBuilder partial_last(String partial_last) {
            this.partial_last = partial_last;
            return this;
        }

        @Generated
        public FluentdEntityBuilder partial_message(String partial_message) {
            this.partial_message = partial_message;
            return this;
        }

        @Generated
        public FluentdEntityBuilder partial_ordinal(String partial_ordinal) {
            this.partial_ordinal = partial_ordinal;
            return this;
        }

        @Generated
        public FluentdEntityBuilder retry_time(String retry_time) {
            this.retry_time = retry_time;
            return this;
        }

        @Generated
        public FluentdEntityBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Generated
        public FluentdEntity build() {
            return new FluentdEntity(this.id, this.logName, this.timestamp, this.log, this.chunk, this.chunk_id, this.container_id, this.container_name, this.error, this.message, this.partial_id, this.partial_last, this.partial_message, this.partial_ordinal, this.retry_time, this.source);
        }

        @Generated
        public String toString() {
            return "FluentdEntity.FluentdEntityBuilder(id=" + this.id + ", logName=" + this.logName + ", timestamp=" + String.valueOf(this.timestamp) + ", log=" + this.log + ", chunk=" + this.chunk + ", chunk_id=" + this.chunk_id + ", container_id=" + this.container_id + ", container_name=" + this.container_name + ", error=" + this.error + ", message=" + this.message + ", partial_id=" + this.partial_id + ", partial_last=" + this.partial_last + ", partial_message=" + this.partial_message + ", partial_ordinal=" + this.partial_ordinal + ", retry_time=" + this.retry_time + ", source=" + this.source + ")";
        }
    }
}

