/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LRUMap<K, V>
extends AbstractMap<K, V> {
    private final LinkedHashMap<K, V> map;
    private final int maxSize;

    public LRUMap(int maxSize) {
        this.maxSize = maxSize;
        int initialCapacity = (int)Math.ceil((double)maxSize / 0.75) + 1;
        this.map = new LinkedHashMap<K, V>(initialCapacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUMap.this.maxSize;
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }
}

