/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.factory.builder;

import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.esquery.EsQuery;
import com.arms.egovframework.javaservice.esframework.factory.builder.AbstractQueryBuilder;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.MainGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.NativeSearchQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.DocValueField;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.SourceFilter;

public class SearchQueryBuilder
implements AbstractQueryBuilder<NativeSearchQuery> {
    private final String[] fieldIncludes;
    private final int size;
    private final int page;
    private final boolean isPaging;
    private final boolean fetchSource;
    private final BoolQueryBuilder boolQuery;
    private final HighlightBuilder highlightBuilder;
    private final List<FieldSortBuilder> fieldSortBuilders;
    private final NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();

    private SearchQueryBuilder(SearchDocDTO searchDocDTO, EsQuery esQuery) {
        this.fieldIncludes = searchDocDTO.getFieldIncludes();
        this.size = searchDocDTO.getSize();
        this.page = searchDocDTO.getPage();
        this.isPaging = searchDocDTO.isPaging();
        this.fetchSource = this.fieldIncludes != null && this.fieldIncludes.length > 0;
        this.boolQuery = esQuery.getBoolQueryBuilder();
        this.fieldSortBuilders = esQuery.getSortBuilders();
        this.highlightBuilder = esQuery.getHighlightBuilder();
        this.nativeSearchQueryBuilder.withMaxResults(Integer.valueOf(this.size));
        if (this.isPaging) {
            this.nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)this.page, (int)this.size));
        }
        if (this.fetchSource) {
            this.nativeSearchQueryBuilder.withSourceFilter((SourceFilter)new FetchSourceFilter(Boolean.valueOf(false), null, null));
            this.nativeSearchQueryBuilder.withDocValueFields(Arrays.stream(this.fieldIncludes).map(DocValueField::new).toList());
        }
        Optional.ofNullable(this.boolQuery).ifPresent(arg_0 -> ((NativeSearchQueryBuilder)this.nativeSearchQueryBuilder).withQuery(arg_0));
        Optional.ofNullable(this.highlightBuilder).ifPresent(arg_0 -> ((NativeSearchQueryBuilder)this.nativeSearchQueryBuilder).withHighlightBuilder(arg_0));
        Optional.ofNullable(this.fieldSortBuilders).ifPresent(sorts -> sorts.forEach(xva$0 -> this.nativeSearchQueryBuilder.withSorts(new SortBuilder[]{xva$0})));
    }

    public static SearchQueryBuilder of(SearchDocDTO searchDocDTO, EsQuery esQuery) {
        return new SearchQueryBuilder(searchDocDTO, esQuery);
    }

    public static SearchQueryBuilder of(EsQuery esQuery) {
        return new SearchQueryBuilder(new MainGroupDTO(){}, esQuery);
    }

    @Override
    public NativeSearchQuery create() {
        return this.nativeSearchQueryBuilder.build();
    }

    @Override
    public NativeSearchQuery createForRecentTrue(Class<? extends BaseEntity> entityClass) {
        String recentFieldName = ReflectionUtil.fieldInfo(entityClass, Recent.class).getName();
        this.boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)recentFieldName, (boolean)true));
        return this.nativeSearchQueryBuilder.build();
    }

    @Generated
    public String[] getFieldIncludes() {
        return this.fieldIncludes;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public boolean isPaging() {
        return this.isPaging;
    }

    @Generated
    public boolean isFetchSource() {
        return this.fetchSource;
    }

    @Generated
    public BoolQueryBuilder getBoolQuery() {
        return this.boolQuery;
    }

    @Generated
    public HighlightBuilder getHighlightBuilder() {
        return this.highlightBuilder;
    }

    @Generated
    public List<FieldSortBuilder> getFieldSortBuilders() {
        return this.fieldSortBuilders;
    }

    @Generated
    public NativeSearchQueryBuilder getNativeSearchQueryBuilder() {
        return this.nativeSearchQueryBuilder;
    }
}

