package com.arms.api.issue.almapi.controller;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOResponse;
import com.arms.api.issue.almapi.service.IssueService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/{connectId}/jira/issue")
public class IssueController {
    
    @Autowired
    private IssueService issueService;

    @ResponseBody
    @RequestMapping(
            value = {""},
            method = {RequestMethod.POST}
    )
    public AlmIssueVOResponse createIssue(@PathVariable("connectId") String connectId,
                                          @RequestBody AlmIssueDTO almIssueDTO) {

        if (almIssueDTO == null) {
            log.error("createIssue Error almIssueCreationDTO is null");
            throw new IllegalArgumentException("createIssue Error almIssueCreationDTO is null");
        }
        almIssueDTO.setServerId(connectId);
        return issueService.createIssue(almIssueDTO).toAlmIssueResponseVO();
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{issueKeyOrId}"},
            method = {RequestMethod.PUT}
    )
    public Map<String,Object> 이슈_수정하기( @PathVariable("connectId") String connectId,
                                            @PathVariable("issueKeyOrId") String issueKeyOrId,
                                            @RequestBody AlmIssueDTO almIssueDTO) {

        log.info("이슈_수정하기 :: connectId :: {} :: 지라이슈생성_데이터 :: {}",
                                            connectId, almIssueDTO.toString());

        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);

        return issueService.updateIssue(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{issueKeyOrId}/{statusId}"},
            method = {RequestMethod.PUT, RequestMethod.POST}
    )
    public Map<String,Object> 이슈_상태_변경하기( @PathVariable("connectId") String connectId,
                                                @PathVariable("issueKeyOrId") String issueKeyOrId,
                                                @PathVariable("statusId") String statusId) {

        log.info("이슈_상태_변경하기 :: connectId :: {} :: issueKeyOrId :: {} :: 상태_아이디 :: {}",
                connectId, issueKeyOrId, statusId);

        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);
        almIssueDTO.setStatusId(statusId);

        return issueService.updateIssueStatus(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{issueKeyOrId}"},
            method = {RequestMethod.DELETE}
    )
    public Map<String,Object> 이슈_삭제하기(@PathVariable("connectId") String connectId,
                                            @PathVariable("issueKeyOrId") String issueKeyOrId) {

        log.info("이슈_삭제하기 :: connectId :: {} :: issueKeyOrId :: {}",
                                            connectId, issueKeyOrId);

        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);

        return issueService.deleteIssue(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/{issueKeyOrId}"},
            method = {RequestMethod.GET}
    )
    public AlmIssueVOResponse 이슈_상세정보_가져오기(@PathVariable("connectId") String connectId,
                                           @PathVariable("issueKeyOrId") String issueKeyOrId)  {

        log.info("이슈_상세정보_가져오기 :: connectId : {}, issueKeyOrId : {}",
                                                    connectId, issueKeyOrId);

        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);

        return issueService.getIssue(almIssueDTO).toAlmIssueResponseVO();
    }

}
