package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.api.admin.indexstatus.service.IndexStatusService;
import com.arms.egovframework.javaservice.esframework.annotation.IndexStatusSnapShot;
import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import com.arms.egovframework.javaservice.esframework.model.entity.JobStatus;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Slf4j
@Aspect
@Component
@AllArgsConstructor
public class IndexStatusSaveAspect {

    private final EsCommonRepositoryWrapper<IndexStatusEntity> esCommonRepositoryWrapper;

    private final FindRepository findRepository;

    @Around("@annotation(indexStatusSnapShot)")
    public Object indexStatusAspect(ProceedingJoinPoint joinPoint, IndexStatusSnapShot indexStatusSnapShot) throws Throwable {

        Object target = joinPoint.getTarget();

        EsCommonRepository<Object, Serializable> repositoryByClass = findRepository.findRepositoryByClass(indexStatusSnapShot.clazz());

        String uuid = String.valueOf(UUID.randomUUID());
        log.info("BEFORE :: {}",indexStatusSnapShot.value());

        this.saveIndexStatus(repositoryByClass.indexAliasName(),getCatIndexVOList(repositoryByClass),uuid, JobStatus.BEFORE);

        Object joinPointResult = joinPoint.proceed();
        log.info("AFTER :: {}",indexStatusSnapShot.value());

        this.saveIndexStatus(repositoryByClass.indexAliasName(),getCatIndexVOList(repositoryByClass),uuid,JobStatus.AFTER);

        return joinPointResult;

    }

    private List<CatIndexVO> getCatIndexVOList(EsCommonRepository<Object, Serializable> repositoryByClass) {
        List<CatIndexVO> catIndexVOS = repositoryByClass.catIndexVOList();
        return new ArrayList<>(catIndexVOS);
    }

    private void saveIndexStatus(String indexAlias, List<CatIndexVO> catIndexVOList, String jobId, JobStatus jobStatus) {

        if(jobId==null){
            throw new IllegalArgumentException("jobId is null");
        }

        for (CatIndexVO catIndexVO : catIndexVOList) {
            IndexStatusEntity indexStatusEntity = catIndexVO.toEntity();
            indexStatusEntity.setIndexAlias(indexAlias);
            indexStatusEntity.setJobId(jobId);
            indexStatusEntity.setJobStatus(jobStatus);
            this.esCommonRepositoryWrapper.save(indexStatusEntity);
        }

    }
}
