/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.configserver.controller;

import com.arms.api.configserver.model.ArmsApplicationProperties;
import com.arms.api.util.aspect.SlackSendAlarm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;

@RestController
@RequestMapping(value={"/api/config-server"})
public class ConfigServerWebhookController {
    private static final Logger log = LoggerFactory.getLogger(ConfigServerWebhookController.class);
    private final WebClient.Builder webClientBuilder;
    private final ArmsApplicationProperties armsApplicationProperties;

    @PostMapping(value={"/config-changed"})
    @SlackSendAlarm(messageOnEnd="A-RMS MSA \ud658\uacbd \ud30c\uc77c \ub9ac\ud50c\ub808\uc2dc \ubc0f \uc801\uc6a9 \uc644\ub8cc")
    public ResponseEntity<String> handlerConfigChanged(@RequestBody Map<String, Object> payload) {
        List changedFiles = this.extractChangedFiles(payload);
        Set matchedKeys = this.extractMsaUrls(changedFiles);
        matchedKeys.forEach(serviceKey -> {
            ArmsApplicationProperties.ConfigClientUrl connectUrl = (ArmsApplicationProperties.ConfigClientUrl)this.armsApplicationProperties.getUrls().get(serviceKey);
            if (connectUrl != null) {
                String refreshUrl = connectUrl.getUrl() + "/actuator/refresh";
                log.info("[ConfigServerWebhookController :: handlerConfigChanged ] :: refreshUrl => {}", (Object)refreshUrl);
                this.sendRefreshRequest(refreshUrl);
            }
        });
        return ResponseEntity.ok((Object)"Processed");
    }

    private List<String> extractChangedFiles(Map<String, Object> payload) {
        ArrayList<String> files = new ArrayList<String>();
        List commits = (List)payload.get("commits");
        if (commits != null) {
            for (Map commit : commits) {
                files.addAll(commit.getOrDefault("added", Collections.emptyList()));
                files.addAll(commit.getOrDefault("modified", Collections.emptyList()));
                files.addAll(commit.getOrDefault("removed", Collections.emptyList()));
            }
        }
        log.info("[ConfigServerWebhookController :: extractChangedFiles ] :: files.size => {}", (Object)files.size());
        return files;
    }

    private void sendRefreshRequest(String url) {
        ((WebClient.RequestBodySpec)this.webClientBuilder.build().post().uri(url, new Object[0])).retrieve().bodyToMono(String.class).doOnSuccess(r -> System.out.println("Refreshed: " + url)).doOnError(e -> System.err.println("Error refreshing " + url + ": " + e.getMessage())).subscribe();
    }

    private Set<String> extractMsaUrls(List<String> changedFiles) {
        HashSet<String> keys = new HashSet<String>();
        Pattern pattern = Pattern.compile("javaServiceTreeFramework(\\w+?)(Core|Fire|Proxy|Hub|AI)?(?:-(dev|stg|live))?\\.yml");
        for (String file : changedFiles) {
            Matcher matcher = pattern.matcher(file);
            if (!matcher.find()) continue;
            String rawKeyGroup1 = matcher.group(1).toLowerCase();
            String rawKeyGroup2 = matcher.group(2);
            Object rawKey = rawKeyGroup1;
            if (rawKeyGroup2 != null && !rawKeyGroup2.isEmpty()) {
                rawKey = (String)rawKey + "-" + rawKeyGroup2.toLowerCase();
            }
            keys.add((String)rawKey);
        }
        return keys;
    }

    public ConfigServerWebhookController(WebClient.Builder webClientBuilder, ArmsApplicationProperties armsApplicationProperties) {
        this.webClientBuilder = webClientBuilder;
        this.armsApplicationProperties = armsApplicationProperties;
    }
}

