/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.languageconfig.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LanguagePackFileReader {
    private static final Logger log = LoggerFactory.getLogger(LanguagePackFileReader.class);
    private static final Pattern LANGUAGE_FILE_PATTERN = Pattern.compile("^[a-z]{2}\\.json$");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getFileInfoFromGitea(String fileUrl, String username, String password) throws Exception {
        log.info("[ GiteaService :: getFileInfoFromGitea ] :: fileUrl => {}", (Object)fileUrl);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(fileUrl).openConnection();
            String auth = username + ":" + password;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
            connection.setRequestProperty("Accept", "application/json");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                    Map map = (Map)mapper.readValue((Reader)reader, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    return map;
                }
                catch (Exception e) {
                    log.error("JSON \ud30c\uc2f1 \uc624\ub958: {}", (Object)e.getMessage(), (Object)e);
                }
            } else {
                log.error("HTTP \uc694\uccad \uc2e4\ud328. \uc751\ub2f5 \ucf54\ub4dc: {}", (Object)responseCode);
            }
            connection.disconnect();
            return null;
        }
        catch (Exception e) {
            log.error("URL \uc5f0\uacb0 \uc624\ub958: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> readLanguagePackFile(String fileUrl, String username, String password) throws Exception {
        log.info("[ LanguagePackFileReader :: readLanguagePackFile ] :: fileUrl => {}", (Object)fileUrl);
        try {
            HttpURLConnection connection;
            block9: {
                connection = (HttpURLConnection)new URL(fileUrl).openConnection();
                String auth = username + ":" + password;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                connection.setRequestProperty("Accept", "application/json");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        ObjectMapper mapper = new ObjectMapper();
                        Map response = (Map)mapper.readValue((Reader)reader, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                        String content = (String)response.get("content");
                        if (content != null) {
                            byte[] decodedBytes = Base64.getDecoder().decode(content);
                            String jsonContent = new String(decodedBytes);
                            Map map = (Map)mapper.readValue(jsonContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                            return map;
                        }
                        break block9;
                    }
                }
                log.error("HTTP \uc694\uccad \uc2e4\ud328. \uc751\ub2f5 \ucf54\ub4dc: {}", (Object)responseCode);
            }
            connection.disconnect();
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            log.error("\uc5b8\uc5b4\ud329 \ud30c\uc77c \uc77d\uae30 \uc624\ub958: {}", (Object)e.getMessage(), (Object)e);
        }
        return new HashMap<String, Object>();
    }

    public static Map<String, String> flattenLanguagePack(Map<String, Object> languagePack) {
        HashMap<String, String> flattened = new HashMap<String, String>();
        LanguagePackFileReader.flattenMap(languagePack, (String)"", flattened);
        return flattened;
    }

    private static void flattenMap(Map<String, Object> map, String prefix, Map<String, String> result) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                LanguagePackFileReader.flattenMap((Map)nestedMap, (String)key, result);
                continue;
            }
            result.put(key, value != null ? value.toString() : null);
        }
    }

    public static Map<String, Object> unflattenLanguagePack(Map<String, String> flattenedPack) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : flattenedPack.entrySet()) {
            String[] keyParts = entry.getKey().split("\\.");
            Map<String, Object> current = result;
            for (int i = 0; i < keyParts.length - 1; ++i) {
                current = (Map)current.computeIfAbsent(keyParts[i], k -> new HashMap());
            }
            current.put(keyParts[keyParts.length - 1], entry.getValue());
        }
        return result;
    }
}

