/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aspect;

import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import java.util.Calendar;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAndSlackNotifyAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAndSlackNotifyAspect.class);
    private final SlackNotificationService slackNotificationService;

    @Around(value="@annotation(com.arms.api.util.aspect.LogAndSlackNotify)")
    public Object logAndSlackNotify(ProceedingJoinPoint joinPoint) throws Throwable {
        String methodName = joinPoint.getSignature().getName();
        String startMessage = String.format("[ \uc554\uc2a4\uc2a4\ucf00\uc974\ub7ec :: %s ] \ub3d9\uc791 \uc2dc\uc791 : %s", methodName, Calendar.getInstance().getTime());
        log.info(startMessage);
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.globalconfig, startMessage);
        Object result = joinPoint.proceed();
        String endMessage = String.format("[ \uc554\uc2a4\uc2a4\ucf00\uc974\ub7ec :: %s ] \ub3d9\uc791 \uc885\ub8cc : %s", methodName, Calendar.getInstance().getTime());
        log.info(endMessage);
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.globalconfig, endMessage);
        log.info("[ LogAndSlackNotifyAspect ] : Method {} returned value : {}", (Object)methodName, result);
        return result;
    }

    public LogAndSlackNotifyAspect(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

