/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.gcframework.provider;

import com.arms.config.GiteaUserConfig;
import com.arms.egovframework.javaservice.gcframework.model.FileContent;
import com.arms.egovframework.javaservice.gcframework.model.GitFileInfo;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;
import com.arms.egovframework.javaservice.gcframework.provider.GitRepositoryProvider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GiteaRepositoryProvider
implements GitRepositoryProvider {
    private static final Logger log = LoggerFactory.getLogger(GiteaRepositoryProvider.class);
    private final GiteaUserConfig giteaUserConfig;
    private final ObjectMapper objectMapper;

    public GiteaRepositoryProvider(GiteaUserConfig giteaUserConfig, ObjectMapper objectMapper) {
        this.giteaUserConfig = giteaUserConfig;
        this.objectMapper = objectMapper;
    }

    public RepoType getType() {
        return RepoType.GITEA;
    }

    private String getBaseApiUrl(String owner, String repoName) {
        return String.format("%s/api/v1/repos/%s/%s/contents", this.giteaUserConfig.getBaseUrl(), owner, repoName);
    }

    private HttpURLConnection createAuthenticatedConnection(String requestUrl, String method) throws Exception {
        URL url = new URL(requestUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoOutput(false);
        if ("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method)) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
        }
        return connection;
    }

    public List<GitFileInfo> getListFilesAndDirectories(String owner, String repoName, String directoryPath, String branch) {
        String requestUrl = String.format("%s/%s?ref=%s", this.getBaseApiUrl(owner, repoName), directoryPath, branch);
        log.info("[GiteaRepositoryProvider] Listing directory:: requestUrl => {}", (Object)requestUrl);
        try {
            HttpURLConnection connection = this.createAuthenticatedConnection(requestUrl, "GET");
            List fileInfos = (List)this.readJsonResponse(connection, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (fileInfos != null) {
                fileInfos.forEach(info -> {
                    if (info.getUrl() != null) {
                        info.setUrl(this.rewriteUrlToInternal(info.getUrl()));
                    }
                });
            }
            return fileInfos;
        }
        catch (Exception e) {
            log.error("Failed to get File list of Gitea repository -> repoName => {}: {}", new Object[]{repoName, e.getMessage(), e});
            throw new RuntimeException("Gitea repository file listing is failed: " + e.getMessage(), e);
        }
    }

    public FileContent getFileContent(String owner, String repoName, String branch, String filePath) {
        String requestUrl = String.format("%s/%s?ref=%s", this.getBaseApiUrl(owner, repoName), filePath, branch);
        log.info("[GiteaRepositoryProvider] Getting file content: {}", (Object)requestUrl);
        try {
            HttpURLConnection connection = this.createAuthenticatedConnection(requestUrl, "GET");
            Map response = (Map)this.readJsonResponse(connection, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (response != null && response.containsKey("content")) {
                FileContent fileContent = new FileContent();
                fileContent.setFileName((String)response.get("name"));
                fileContent.setFilePath((String)response.get("path"));
                fileContent.setContent((String)response.get("content"));
                fileContent.setEncoding((String)response.get("encoding"));
                fileContent.setSha((String)response.get("sha"));
                Object sizeObj = response.get("size");
                if (sizeObj instanceof Number) {
                    fileContent.setSize(((Number)sizeObj).longValue());
                }
                return fileContent;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to get Gitea file content {}: {}", new Object[]{filePath, e.getMessage(), e});
            throw new RuntimeException("Gitea file content retrieval failed: " + e.getMessage(), e);
        }
    }

    public boolean upsertFile(String owner, String repoName, String branch, String filePath, String content, String commitMessage) {
        String requestUrl = String.format("%s/%s", this.getBaseApiUrl(owner, repoName), filePath);
        log.info("[GiteaRepositoryProvider] Upserting file: {}", (Object)requestUrl);
        try {
            HttpURLConnection connection = this.createAuthenticatedConnection(requestUrl, "PUT");
            Map<String, String> requestBody = Map.of("message", commitMessage, "content", Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8)), "branch", branch);
            this.writeRequestBody(connection, requestBody);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                log.info("Successfully upserted Gitea file: {}", (Object)filePath);
                return true;
            }
            String errorMessage = this.readErrorStream(connection);
            log.error("Failed to upsert Gitea file {}. HTTP Error {}: {}", new Object[]{filePath, responseCode, errorMessage});
            throw new RuntimeException("Gitea file upsert failed: " + errorMessage + " (Code: " + responseCode + ")");
        }
        catch (Exception e) {
            log.error("Failed to upsert Gitea file {}: {}", new Object[]{filePath, e.getMessage(), e});
            throw new RuntimeException("Gitea file upsert failed: " + e.getMessage(), e);
        }
    }

    public boolean deleteFile(String owner, String repoName, String branch, String filePath, String commitMessage) {
        String requestUrl = String.format("%s/%s", this.getBaseApiUrl(owner, repoName), filePath);
        log.info("[GiteaRepositoryProvider] Deleting file: {}", (Object)requestUrl);
        try {
            FileContent existingFile = this.getFileContent(owner, repoName, branch, filePath);
            if (existingFile == null || existingFile.getSha() == null) {
                log.warn("File {} not found or SHA missing for deletion. Cannot proceed with delete.", (Object)filePath);
                return false;
            }
            String fileSha = existingFile.getSha();
            HttpURLConnection connection = this.createAuthenticatedConnection(requestUrl, "DELETE");
            Map<String, String> requestBody = Map.of("message", commitMessage, "branch", branch, "sha", fileSha);
            this.writeRequestBody(connection, requestBody);
            int responseCode = connection.getResponseCode();
            if (responseCode == 204) {
                log.info("Successfully deleted Gitea file: {}", (Object)filePath);
                return true;
            }
            String errorMessage = this.readErrorStream(connection);
            log.error("Failed to delete Gitea file {}. HTTP Error {}: {}", new Object[]{filePath, responseCode, errorMessage});
            throw new RuntimeException("Gitea file deletion failed: " + errorMessage + " (Code: " + responseCode + ")");
        }
        catch (Exception e) {
            log.error("Failed to delete Gitea file {}: {}", new Object[]{filePath, e.getMessage(), e});
            throw new RuntimeException("Gitea file deletion failed: " + e.getMessage(), e);
        }
    }

    private String rewriteGiteaUrl(String downloadUrl) {
        if (downloadUrl != null && downloadUrl.contains("/src/branch/")) {
            return downloadUrl.replace("/src/branch/", "/raw/branch/");
        }
        return downloadUrl;
    }

    private String rewriteUrlToInternal(String url) {
        String regex = "(https?://)([^/]+)(/gitea)";
        return url.replaceAll(regex, this.giteaUserConfig.getReplaceUrl());
    }

    private <T> T readJsonResponse(HttpURLConnection connection, TypeReference<T> typeRef) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode != 200 && responseCode != 201 && responseCode != 204) {
            String errorMessage = this.readErrorStream(connection);
            log.error("HTTP Error {}: {}", (Object)responseCode, (Object)errorMessage);
            throw new RuntimeException("Failed to process Gitea request. Response Code: " + responseCode + ", Message: " + errorMessage);
        }
        if (responseCode == 204) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            Object object = this.objectMapper.readValue((Reader)reader, typeRef);
            return (T)object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readErrorStream(HttpURLConnection connection) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
            if (reader != null) {
                String string = reader.lines().collect(Collectors.joining("\n"));
                return string;
            }
            String string = "No error message available from stream.";
            return string;
        }
        catch (Exception e) {
            log.error("Failed to read error stream", (Throwable)e);
            return "Unknown error while reading error stream: " + e.getMessage();
        }
    }

    private void writeRequestBody(HttpURLConnection connection, Map<String, Object> body) throws Exception {
        try (OutputStream os = connection.getOutputStream();){
            os.write(this.objectMapper.writeValueAsBytes(body));
            os.flush();
        }
    }
}

