////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"],
		["../reference/jquery-plugins/twbs-pagination-master/jquery.twbsPagination.min.js"]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();

			var boardComponents = (function () {
				return {
					loading: function () {
						return $(
							`<li
								role="status"
								class="list-group-item list-group-item-action util-animate-pulse">
								<h4 class="list-group-item-heading util-mb-4 util-h-4 util-w-48 util-rounded-full util-bg-gray-300 dark:util-bg-gray-600"></h4>

								<p class="list-group-item-text util-h-2.5 util-w-64 util-rounded-full util-bg-gray-200 dark:util-bg-gray-700"></p>

								<span class="sr-only">Loading...</span>
							</li>`
						);
					},
					main: function (board) {
						return $(
							`<section class="search-result">
								<h4>
									<a
										href="/cover/template.html?page=inquiryDetail&id=${board.id}"
										class="util-truncate">
										${board.subjectName}
									</a>
								</h4>
								<p class="text-success">
									<i class="fa fa-user"></i>
									${board.userName}
								</p>
								<p>
									<span class="util-mr-2">
										<i class="fa-solid fa-eye"></i>
										${board.viewCount || 0}
									</span>
									<span>${new Date(board.createdDate).toLocaleString()}</span>
								</p>
							</section>`
						);
					},
					noData: function () {
						return $(
							`<li class="list-group-item list-group-item-action">
								<p class="list-group-item-text text-center util-py-8 util-text-base">
									<i class="fa-solid fa-text-slash"></i>
									등록된 게시글이 없습니다.
								</p>
							</li>`
						);
					}
				};
			})();

			var drawBoardList = function (_page, _subjectName) {
				var $bbs = $("#bbs");
				var SIZE = 10;

				var requestBody = {
					size: SIZE,
					page: _page
				};

				if (_subjectName) {
					requestBody.subjectName = _subjectName + "*";
				}

				$.ajax({
					url: "/bbs/board-list/only-post-list",
					type: "GET",
					data: requestBody,
					beforeSend: function () {
						$bbs.html(boardComponents.loading());
					},
					success: function (data) {
						$("#total_counts").text(data.response.totalHits);

						var pageCount = Math.ceil(data.response.totalHits / SIZE);
						$(".pagination").twbsPagination({
							totalPages: pageCount,
							visiblePages: 7,
							first: "<i class='fa fa-angle-double-left'></i>",
							prev: "<i class='fa fa-angle-left'></i>",
							next: "<i class='fa fa-angle-right'></i>",
							last: "<i class='fa fa-angle-double-right'></i>"
						});

						$bbs.empty();

						if (data.response.bbsEntities.length <= 0) {
							return $bbs.append(boardComponents.noData());
						}

						data.response.bbsEntities.forEach(function (board) {
							$bbs.append(boardComponents.main(board));
						});
					}
				});
			};
			drawBoardList(0);

			$(".pagination").on("page", function (event, page) {
				drawBoardList(page - 1, searchQuery);
			});

			var searchQuery = "";
			$("#search_form").on("submit", function (event) {
				event.preventDefault();

				searchQuery = $(event.target).find("input").val();
				drawBoardList(0, searchQuery);
			});
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}
