/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.sample;

import com.arms.api.sample.MyPagePdfDocumentReader;
import com.arms.api.sample.logging.SimpleLogAdvisor;
import com.arms.api.sample.safeguard.SafeGuardAdvisor;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.RetrievalAugmentationAdvisor;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.document.Document;
import org.springframework.ai.rag.generation.augmentation.ContextualQueryAugmenter;
import org.springframework.ai.rag.generation.augmentation.QueryAugmenter;
import org.springframework.ai.rag.retrieval.search.DocumentRetriever;
import org.springframework.ai.rag.retrieval.search.VectorStoreDocumentRetriever;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
class SampleController {
    private final ConcurrentHashMap<String, AtomicBoolean> streamStatus = new ConcurrentHashMap();
    private final ChatModel chatModel;
    private final VectorStore vectorStore;
    private final MyPagePdfDocumentReader myPagePdfDocumentReader;
    private final SimpleLogAdvisor simpleLogAdvisor;
    private final SafeGuardAdvisor safeGuardAdvisor;

    @GetMapping(value={"/ai/test"})
    public List<Document> getTest(@RequestParam(value="message") String message) {
        List results = this.vectorStore.similaritySearch(message);
        return results;
    }

    @GetMapping(value={"/ai/my-page-pdf-document-reader"})
    public List<Document> getMyPagePdfDocumentReader() {
        return this.myPagePdfDocumentReader.getDocsFromPdf();
    }

    @GetMapping(value={"/ai/stopStream"})
    public String stopStream(@RequestParam(value="streamId") String streamId) {
        if (this.streamStatus.containsKey(streamId)) {
            this.streamStatus.get(streamId).set(true);
            return "\uc2a4\ud2b8\ub9bc " + streamId + " \uc911\ub2e8";
        }
        return "\ud574\ub2f9 stream ID\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @GetMapping(value={"/ai/generateStream"})
    public Flux<String> generateStream(@RequestParam(value="message", defaultValue="\uc624\ub298 \ub0a0\uc528 \uc5b4\ub54c?") String message, @RequestParam(value="streamId") String streamId) {
        this.streamStatus.put(streamId, new AtomicBoolean(false));
        ChatClient chatClient = ChatClient.builder((ChatModel)this.chatModel).build();
        PromptTemplate promptTemplate = new PromptTemplate("\tContext information is below.\n\n\t---------------------\n\t{context}\n\t---------------------\n\n\tGiven the context information and no prior knowledge, answer the query.\n\n\tFollow these rules:\n\n\t\t\uc8fc\uc5b4\uc9c4 \uc694\uccad\uc5d0 \ub300\ud55c \uc81c\uacf5\ub41c \ub0b4\uc6a9\uc740 \uc815\ubcf4\ub97c \ubc14\ud0d5\uc73c\ub85c, \uc0ac\uc804 \uc9c0\uc2dd \uc5c6\uc774 \uc0ac\uc6a9\uc790 \ub313\uae00\uc5d0 \ub2f5\ubcc0\ud558\uc138\uc694.\n\t\t\uadf8\ub9bc\uc774\ub098 \ud45c\uac00 \ub4e4\uc5b4\uac00\ub294 \ub2e8\uc5b4\ub294 \uc81c\uc678\ud558\uace0 \ucc3e\uc544\uc918.\n\t\t\ubb38\uc7a5\uc774 \ub05d\ub098\uba74 \uac1c\ud589\ud574\uc918.\n\t\t\ub9cc\uc57d \uc694\uccad\uc5d0 \ub2f5\uc774 \uc5c6\ub2e4\uba74, \uc601\uc5b4\ub85c \ub300\ub2f5\ud558\uc9c0 \ub9d0\uace0 \ud55c\uad6d\uc5b4\ub85c \uc0ac\uc6a9\uc790\uc5d0\uac8c \ub2f5\ubcc0\uc744 \ud560 \uc218 \uc5c6\ub2e4\uace0 \uc54c\ub824\uc8fc\uc138\uc694.\n\n\tQuery: {query}\n\n\tAnswer:\n");
        RetrievalAugmentationAdvisor retrievalAugmentationAdvisor = RetrievalAugmentationAdvisor.builder().documentRetriever((DocumentRetriever)VectorStoreDocumentRetriever.builder().similarityThreshold(Double.valueOf(0.5)).vectorStore(this.vectorStore).build()).queryAugmenter((QueryAugmenter)ContextualQueryAugmenter.builder().allowEmptyContext(Boolean.valueOf(false)).promptTemplate(promptTemplate).build()).build();
        return chatClient.prompt().advisors(new Advisor[]{this.simpleLogAdvisor, this.safeGuardAdvisor, retrievalAugmentationAdvisor}).user(message).stream().content().takeUntil(data -> this.streamStatus.get(streamId).get()).doOnComplete(() -> this.streamStatus.remove(streamId)).doOnError(error -> this.streamStatus.remove(streamId));
    }

    @Generated
    public SampleController(ChatModel chatModel, VectorStore vectorStore, MyPagePdfDocumentReader myPagePdfDocumentReader, SimpleLogAdvisor simpleLogAdvisor, SafeGuardAdvisor safeGuardAdvisor) {
        this.chatModel = chatModel;
        this.vectorStore = vectorStore;
        this.myPagePdfDocumentReader = myPagePdfDocumentReader;
        this.simpleLogAdvisor = simpleLogAdvisor;
        this.safeGuardAdvisor = safeGuardAdvisor;
    }
}

