/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.admin.indexstatus.model.vo;

import com.arms.api.admin.indexstatus.model.vo.IndexStatusVO;
import com.arms.api.admin.indexstatus.model.vo.IndexStatusWithJobIdVO;
import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class IndexStatusesWithJobIdVO {
    private String jobId;
    private String indexAliasName;
    private final Set<String> beforeJobIndexNames = new HashSet<String>();
    private Integer beforeIndexCount;
    private final Set<String> afterJobIndexNames = new HashSet<String>();
    private Integer afterIndexCount;
    private Date jobStartTime;
    private Date jobEndTime;
    private final List<IndexStatusWithJobIdVO> jobHistories = new ArrayList<IndexStatusWithJobIdVO>();

    public static IndexStatusesWithJobIdVO from(Map.Entry<String, List<IndexStatusEntity>> listEntry) {
        List<IndexStatusEntity> indexStatusEntities = listEntry.getValue();
        Map<String, List<IndexStatusEntity>> indexStatusEntitiesGroupByIndexName = indexStatusEntities.stream().collect(Collectors.groupingBy(IndexStatusEntity::getIndex));
        IndexStatusesWithJobIdVO indexStatusesWithJobIdVO = IndexStatusesWithJobIdVO.builder().jobId(listEntry.getKey()).indexAliasName(listEntry.getValue().stream().findAny().map(IndexStatusEntity::getIndexAlias).orElse("")).build();
        indexStatusEntitiesGroupByIndexName.entrySet().forEach(index -> indexStatusesWithJobIdVO.setIndexStatusesWithJobIdVO(new IndexStatusWithJobIdVO((Map.Entry<String, List<IndexStatusEntity>>)index)));
        return indexStatusesWithJobIdVO;
    }

    public void setIndexStatusesWithJobIdVO(IndexStatusWithJobIdVO indexStatusWithJobIdVO) {
        this.addHistory(indexStatusWithJobIdVO);
        this.setTimestamp(indexStatusWithJobIdVO);
        this.setIndexCount(indexStatusWithJobIdVO);
    }

    private void addHistory(IndexStatusWithJobIdVO indexStatusWithJobIdVO) {
        this.jobHistories.add(indexStatusWithJobIdVO);
    }

    private void setTimestamp(IndexStatusWithJobIdVO indexStatusWithJobIdVO) {
        IndexStatusVO beforeIndexStatusVO = indexStatusWithJobIdVO.getBeforeIndexStatusVO();
        IndexStatusVO afterIndexStatusVO = indexStatusWithJobIdVO.getAfterIndexStatusVO();
        if (beforeIndexStatusVO != null) {
            if (this.jobStartTime == null) {
                this.jobStartTime = beforeIndexStatusVO.getTimestamp();
            }
            if (this.jobStartTime.after(beforeIndexStatusVO.getTimestamp())) {
                this.jobStartTime = beforeIndexStatusVO.getTimestamp();
            }
        }
        if (afterIndexStatusVO != null) {
            if (this.jobEndTime == null) {
                this.jobEndTime = afterIndexStatusVO.getTimestamp();
            }
            if (this.jobEndTime.before(afterIndexStatusVO.getTimestamp())) {
                this.jobEndTime = afterIndexStatusVO.getTimestamp();
            }
        }
    }

    private void setIndexCount(IndexStatusWithJobIdVO indexStatusWithJobIdVO) {
        IndexStatusVO beforeIndexStatusVO = indexStatusWithJobIdVO.getBeforeIndexStatusVO();
        IndexStatusVO afterIndexStatusVO = indexStatusWithJobIdVO.getAfterIndexStatusVO();
        if (beforeIndexStatusVO != null) {
            this.beforeJobIndexNames.add(beforeIndexStatusVO.getIndexName());
            this.beforeIndexCount = this.beforeJobIndexNames.size();
        }
        if (afterIndexStatusVO != null) {
            this.afterJobIndexNames.add(afterIndexStatusVO.getIndexName());
            this.afterIndexCount = this.afterJobIndexNames.size();
        }
    }

    @Generated
    public static IndexStatusesWithJobIdVOBuilder builder() {
        return new IndexStatusesWithJobIdVOBuilder();
    }

    @Generated
    public IndexStatusesWithJobIdVO(String jobId, String indexAliasName, Integer beforeIndexCount, Integer afterIndexCount, Date jobStartTime, Date jobEndTime) {
        this.jobId = jobId;
        this.indexAliasName = indexAliasName;
        this.beforeIndexCount = beforeIndexCount;
        this.afterIndexCount = afterIndexCount;
        this.jobStartTime = jobStartTime;
        this.jobEndTime = jobEndTime;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getIndexAliasName() {
        return this.indexAliasName;
    }

    @Generated
    public Integer getBeforeIndexCount() {
        return this.beforeIndexCount;
    }

    @Generated
    public Integer getAfterIndexCount() {
        return this.afterIndexCount;
    }

    @Generated
    public Date getJobStartTime() {
        return this.jobStartTime;
    }

    @Generated
    public Date getJobEndTime() {
        return this.jobEndTime;
    }

    @Generated
    public List<IndexStatusWithJobIdVO> getJobHistories() {
        return this.jobHistories;
    }

    @Generated
    public static class IndexStatusesWithJobIdVOBuilder {
        @Generated
        private String jobId;
        @Generated
        private String indexAliasName;
        @Generated
        private Integer beforeIndexCount;
        @Generated
        private Integer afterIndexCount;
        @Generated
        private Date jobStartTime;
        @Generated
        private Date jobEndTime;

        @Generated
        IndexStatusesWithJobIdVOBuilder() {
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder indexAliasName(String indexAliasName) {
            this.indexAliasName = indexAliasName;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder beforeIndexCount(Integer beforeIndexCount) {
            this.beforeIndexCount = beforeIndexCount;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder afterIndexCount(Integer afterIndexCount) {
            this.afterIndexCount = afterIndexCount;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder jobStartTime(Date jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVOBuilder jobEndTime(Date jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        @Generated
        public IndexStatusesWithJobIdVO build() {
            return new IndexStatusesWithJobIdVO(this.jobId, this.indexAliasName, this.beforeIndexCount, this.afterIndexCount, this.jobStartTime, this.jobEndTime);
        }

        @Generated
        public String toString() {
            return "IndexStatusesWithJobIdVO.IndexStatusesWithJobIdVOBuilder(jobId=" + this.jobId + ", indexAliasName=" + this.indexAliasName + ", beforeIndexCount=" + this.beforeIndexCount + ", afterIndexCount=" + this.afterIndexCount + ", jobStartTime=" + String.valueOf(this.jobStartTime) + ", jobEndTime=" + String.valueOf(this.jobEndTime) + ")";
        }
    }
}

