/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateRangeUtil {
    public static List<String> getDateRange(String startDateStr, String endDateStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        ArrayList<String> dateList = new ArrayList<String>();
        LocalDate startDate = LocalDate.parse(startDateStr, formatter);
        LocalDate endDate = LocalDate.parse(endDateStr, formatter);
        if (endDate.isBefore(startDate)) {
            return dateList;
        }
        LocalDate current = startDate;
        while (!current.isAfter(endDate)) {
            dateList.add(current.format(formatter));
            current = current.plusDays(1L);
        }
        return dateList;
    }

    public static boolean isWithinDateRange(Date targetDate, String startDateString, String endDateString) {
        if (targetDate == null) {
            return false;
        }
        if (startDateString == null && endDateString == null) {
            return true;
        }
        try {
            Date startDate = null;
            Date endDate = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            if (startDateString != null) {
                startDate = formatter.parse(startDateString);
            }
            if (endDateString != null) {
                endDate = formatter.parse(endDateString);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                endDate = calendar.getTime();
            }
            if (startDate != null && endDate != null) {
                return !targetDate.before(startDate) && !targetDate.after(endDate);
            }
            if (startDate != null) {
                return !targetDate.before(startDate);
            }
            return !targetDate.after(endDate);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isNotWithinDateRange(Date targetDate, String startDateString, String endDateString) {
        return !DateRangeUtil.isWithinDateRange(targetDate, startDateString, endDateString);
    }
}

