package com.arms.api.analysis.scope.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
public class CircularPackingChartVO {

    private String title; // 제목

    private String stateLink; // arms 상태

    private String almState; // alm 상태

    private int linkedIssueCount; // 연관된 이슈 수

    private int subTaskCount; // 하위 이슈 수

    private int numOfWorkers; // 작업자수

    private List<String> workersList; // 작업자 목록

    private String recentId;

    private String issueKey;
    @JsonProperty("creqLink")
    private Long cReqLink;

    private List<Long> versions;

    private Long serviceId;

    private String type;
}
