package com.arms.api.bbs.model.entity;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;

import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.*;

import com.arms.api.bbs.model.constant.BoardType;
import com.arms.api.bbs.model.constant.PostType;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;


@Builder
@AllArgsConstructor
@Getter
@Document(indexName = "bbs")
@Setting(settingPath = "/es-settings/bbs-index-settings.json")
public class BbsEntity implements BaseEntity {

    @Id
    @Field(type = FieldType.Keyword, name = "id")
    private String id;

    @Field(type = FieldType.Keyword, name = "post_type")
    private PostType postType;

    @Field(type = FieldType.Keyword, name = "group_id")
    private String groupId;

    @Field(type = FieldType.Text,
            name = "subject_name",
            analyzer = "ngram_analyzer",
            searchAnalyzer = "standard")
    private String subjectName;

    @Field(type = FieldType.Text, name = "contents")
    private String contents;

    @Field(type = FieldType.Keyword, name = "board_type")
    private BoardType boardType;

    @Field(type = FieldType.Text, name = "user_name")
    private String userName;

    @Field(type = FieldType.Text, name = "password")
    private String password;

    @Field(type = FieldType.Date, name = "created_date")
    @ElasticSearchCreatedDate
    @Setter
    private Date createdDate;

    @Field(type = FieldType.Date, name = "updated_date")
    @ElasticSearchUpdateDate
    @Setter
    private Date updatedDate;

    @Field(type = FieldType.Keyword, name = "path")
    private String path;

    @Field(type = FieldType.Integer, name = "indent")
    private Integer indent;

    @Field(type = FieldType.Integer, name = "view_count")
    private Integer viewCount;

    public void generateGroupId(){
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSSSSSS");
        this.groupId = now.format(formatter);
        this.path = this.groupId;
        this.indent = 0;
    }

    public void generatePath(String parentUpperPath){
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSSSSSS");
        this.groupId = parentUpperPath.split("/")[0];
        this.path = parentUpperPath + "/" +  now.format(formatter);
        this.indent = this.path.split("/").length-1;
    }

    public void updateBbsEntity(BbsEntity bbsEntity){

        if(bbsEntity.subjectName!=null){
            this.subjectName = bbsEntity.subjectName;
        }

        if(bbsEntity.boardType!=null){
            this.boardType = bbsEntity.boardType;
        }

        if(bbsEntity.postType!=null){
            this.postType = bbsEntity.postType;
        }

        if(bbsEntity.path!=null){
            this.path = bbsEntity.path;
        }

        if(bbsEntity.contents!=null){
            this.contents = bbsEntity.contents;
        }
    }

    public void updateGroupIdAndPath(String groupId){
        this.path = this.path.replace(this.groupId,groupId);
        this.groupId = groupId;
    }

    public void viewCountUp(){
        this.viewCount = Optional.ofNullable(this.viewCount).orElse(0)+1 ;
    }

    public void viewCountInit(){
        this.viewCount = Optional.ofNullable(this.viewCount).orElse(0) ;
    }

    private BbsEntity() {}
}
