package com.arms.api.blog.model.entity;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import lombok.*;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;
import java.util.Optional;


@Builder
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Document(indexName = "blog")
public class BlogEntity implements BaseEntity {

    @Id
    @Field(type = FieldType.Keyword, name = "c_id")
    private Long c_id;

    @Field(type = FieldType.Text, name = "c_blog_thumbnail_url")
    @Setter
    private String c_blog_thumbnail_url;

    @Field(type = FieldType.Text, name = "c_blog_title")
    @Setter
    private String c_blog_title;

    @Field(type = FieldType.Text, name = "c_blog_desc")
    @Setter
    private String c_blog_desc;

    @Field(type = FieldType.Text, name = "c_blog_author_id")
    @Setter
    private String c_blog_author_id;

    @Field(type = FieldType.Text, name = "c_blog_contents")
    @Setter
    private String c_blog_contents;

    @Field(type = FieldType.Date, name = "c_blog_created")
    @ElasticSearchCreatedDate
    @Setter
    private Date c_blog_created;

    @Field(type = FieldType.Date, name = "c_blog_updated")
    @ElasticSearchUpdateDate
    @Setter
    private Date c_blog_updated;

    @Field(type = FieldType.Integer, name = "c_blog_view_count")
    @Setter
    private Integer c_blog_view_count;

    public void viewCountUp() {
        this.c_blog_view_count = Optional.ofNullable(this.c_blog_view_count).orElse(0) + 1;
    }

}
