package com.arms.api.issue.almapi.model.vo;

import java.util.*;
import java.util.stream.Collectors;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;

public class AlmIssueVOCollection {

    private final List<AlmIssueVO> almIssueVOs;

    public AlmIssueVOCollection(List<AlmIssueVO> almIssueVOs){
        this.almIssueVOs = almIssueVOs;
    }

    public List<AlmIssueVO> listWithLinkedIssue() {

        Map<String, List<AlmIssueVO>> groupByIssueKey
                = almIssueVOs.stream().collect(Collectors.groupingBy(AlmIssueVO::getKey));

        return groupByIssueKey.values().stream().map(almIssueVOS -> {
            AlmIssueVO almIssueVO = almIssueVOS.stream().findFirst().orElseGet(AlmIssueVO::new);
            almIssueVOS.forEach(almIssueVO::addLinkedIssue);
            return almIssueVO;
        }).collect(Collectors.toList());
    }


    public void add(AlmIssueVO almIssueVO){
        if(!this.almIssueVOs.contains(almIssueVO)){
            this.almIssueVOs.add(almIssueVO);
        }
    }


}
