package com.arms.api.project.controller;

import com.arms.api.project.vo.ProjectVO;
import com.arms.api.project.service.ProjectService;
import com.arms.api.util.errors.ErrorCode;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RestController
@RequestMapping("/{connectId}/jira/project")
@AllArgsConstructor
public class ProjectController {

    private final ProjectService projectService;

    @ResponseBody
    @RequestMapping(
            value = {"/{projectKeyOrId}"},
            method = {RequestMethod.GET}
    )
    public ProjectVO getProject(@PathVariable("connectId") String connectId,
                                @PathVariable("projectKeyOrId") String projectKeyOrId) {

        if (connectId == null) {
            log.error("getProject Error: connectId {}",ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        if (StringUtils.isEmpty(projectKeyOrId)) {
            log.error("getProject Error projectKeyOrId {}", ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
            throw new IllegalArgumentException("getProject Error projectKeyOrId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
        }

        return projectService.getProject(connectId, projectKeyOrId);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/list"},
            method = {RequestMethod.GET}
    )
    public List<ProjectVO> getProjectList(@PathVariable("connectId") String connectId) {

        if (connectId == null) {
            log.error("getProjectList Error: connectId {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getProjectList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        return projectService.getProjectList(connectId);
    }
}