package com.arms.egovframework.javaservice.esframework.esquery.filter;


import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.WildcardQueryBuilder;

public class WildCardQueryFilter extends Filter<WildcardQueryBuilder> {

	private WildcardQueryBuilder wildCardQueryBuilder;


	public WildCardQueryFilter(String name, String value,Boolean caseInsensitive){
		if(name != null && value != null) {
			String replaceValue = value.replaceAll("\\*", "");
			if (!replaceValue.isEmpty() && !replaceValue.equals("null")) {
				this.wildCardQueryBuilder = QueryBuilders.wildcardQuery(name, value).caseInsensitive(caseInsensitive);
			}
		}
	}


	@Override
	public AbstractQueryBuilder<WildcardQueryBuilder> abstractQueryBuilder() {
		return  wildCardQueryBuilder;
	}

}
