package com.arms.api.bbs.service;

import com.arms.api.bbs.model.dto.BbsDTO;
import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.api.bbs.model.vo.BbsVO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.List;

@SpringBootTest(properties = {
        "spring.profiles.active=dev"
})
public class BbsServiceTest {

    @Autowired
    BbsService bbsService;

    @Autowired
    EsCommonRepositoryWrapper<BbsEntity> esCommonRepositoryWrapper;

    @Test
    public void test_bbsList() {
        BbsDTO bbsDTO = new BbsDTO();
        bbsDTO.setPage(0);
        bbsDTO.setSize(10);
        BbsVO bbsVO = bbsService.bbsList(bbsDTO);
        List<BbsEntity> bbsEntities = bbsVO.getBbsEntities();
        bbsEntities.getLast();
        System.out.println("bbsVO.totalHits ===> " + bbsVO.getTotalHits());
        System.out.println("bbsVO.totalHits ===> " + bbsVO.getSearchAfter());
        loopSysOut(bbsEntities);
        BbsDTO bbsDTO1 = new BbsDTO();
        bbsDTO1.setSize(10);
        bbsDTO1.setSearchAfter(bbsVO.getSearchAfter());
        BbsVO bbsVO1 = bbsService.bbsList(bbsDTO1);
        loopSysOut(bbsVO1.getBbsEntities());
    }

    @Test
    public void test_more_than_10000() {
        BbsDTO bbsDTO = new BbsDTO();
        bbsDTO.setPage(0);
        bbsDTO.setSize(10000);
        BbsVO bbsVO = bbsService.bbsList(bbsDTO);
        loopLastContentSysOut(bbsVO.getBbsEntities());
        BbsDTO bbsDTO1 = new BbsDTO();
        bbsDTO1.setSize(10);
        bbsDTO1.setSearchAfter(bbsVO.getSearchAfter());
        BbsVO bbsVO1 = bbsService.bbsList(bbsDTO1);
        loopSysOut(bbsVO1.getBbsEntities());
    }

    private void loopLastContentSysOut(List<BbsEntity> bbsEntities) {
        BbsEntity last = bbsEntities.getLast();
        System.out.println("id -> " + last.getId()+ ", subjectName -> " + last.getSubjectName());
    }

    private void loopSysOut(List<BbsEntity> bbsEntities) {
        for(BbsEntity bbsEntity : bbsEntities) {
            System.out.println("id -> " + bbsEntity.getId()+ ", subjectName -> " + bbsEntity.getSubjectName());
        }
    }
}
