package com.arms.api.issue.almapi.service;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;

import java.io.File;

import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public abstract class WireMockCloudJira2Config {

    protected static WireMockServer mockServer1;

    @BeforeAll
    public void startWireMocks() {
/*
        File mappingFile =  new File("src/test/resources/wiremock/cloud_jira_2/mappings").getAbsoluteFile();
        File file =  new File("src/test/resources/wiremock/cloud_jira_2/__files").getAbsoluteFile();

        if (!mappingFile.exists()) {
            mappingFile.mkdirs();
        }

        if (!file.exists()) {
            file.mkdirs();
        }*/

        mockServer1 = new WireMockServer(
                wireMockConfig()
                        .port(8089)
                        .usingFilesUnderClasspath("wiremock/cloud_jira_2")
        );


//        mockServer1.enableRecordMappings(new SingleRootFileSource(mappingFile),new SingleRootFileSource(file));

        mockServer1.start();

//        mockServer1.startRecording("https://dmove-313dev.atlassian.net");

    }

    @AfterAll
    public void stopWireMocks() {
        if (mockServer1 != null && mockServer1.isRunning()) {
//            mockServer1.stopRecording();
            mockServer1.stop();
        }
    }
}
