package com.arms.api.admin.esIndex.service;

import com.arms.api.admin.esIndex.model.vo.IndexStatusSumVO;
import com.arms.api.admin.almissue.service.AlmIssueIndexAdminService;
import com.arms.api.admin.fluentd.service.FluentdIndexAdminService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@AllArgsConstructor
@Service
public class ElasticSearchIndexAdminServiceImpl implements ElasticSearchIndexAdminService{

    private final AlmIssueIndexAdminService almIssueIndexAdminService;

    private final FluentdIndexAdminService fluentdIndexAdminService;

    @Override
    public List<IndexStatusSumVO> esIndexSumList() {
        return List.of(almIssueIndexAdminService.almIssueIndexSumList()
                ,fluentdIndexAdminService.fluentDIndexSumList());
    }
}
