package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.*;


@Getter
@Slf4j
public class OnPremissJiraIssueVOCollection {

    private final List<OnPremissJiraIssueVO> onPremissJiraIssueVOS;

    public OnPremissJiraIssueVOCollection(List<OnPremissJiraIssueVO> onPremissJiraIssueVOS){
        this.onPremissJiraIssueVOS = onPremissJiraIssueVOS;
    }

    public List<OnPremissJiraIssueVO> appliedLinkedIssuePdServiceVO() {

        Map<OnPremissJiraIssueVO, List<AlmIssueWithRequirementDTO>> onPremissJiraIssueVOListMap
            = onPremissJiraIssueVOS
                .stream()
                .collect(groupingBy(vo -> vo, mapping(OnPremissJiraIssueVO::getAlmIssueWithRequirementDTO, toList())));

        return onPremissJiraIssueVOListMap
                .entrySet()
                .stream().map(a-> a.getKey().appliedLinkedIssuePdServiceElement(a.getValue())).toList();

    }

}
