package com.arms.egovframework.javaservice.scmframework.controller;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.*;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

@Slf4j
@RestController
@RequiredArgsConstructor
public class ScmController {

    @GetMapping("/gitInitTest")
    public ModelAndView gitInitTest(HttpServletRequest request) throws Exception {

        log.info("ScmController :: getNode");
        //create git folder
        File gitDir = new File("./git_init_test");
        if(gitDir.exists()){
            FileUtils.deleteDirectory(gitDir);
        }

        if(gitDir.mkdirs()){
            log.info("dir create success");
        }
        //init
        Git git = Git.init().setDirectory(gitDir).call();
        git.close();

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", git.log());
        return modelAndView;
    }

    @GetMapping("/gitHubCloneTest")
    public ModelAndView gitHubCloneTest(HttpServletRequest request) throws Exception {

        //create git folder
        File gitDir = new File("./git_hub_clone_test");
        if(gitDir.exists()){
            FileUtils.deleteDirectory(gitDir);
        }

        if(gitDir.mkdirs()){
            log.info("dir create success");
        }

        //set username, access token
        CredentialsProvider credentialsProvider
                = new UsernamePasswordCredentialsProvider(
                "313cokr@gmail.com"
                , "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"); //access token

        //clone
        Git git = Git.cloneRepository()
                .setURI("https://github.com/313DEVGRP/Java-Service-Tree-Framework-Auto-Code.git")
                .setCredentialsProvider(credentialsProvider)
                .setDirectory(gitDir)
                .call();
        git.close();

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", git.log());
        return modelAndView;
    }

    @GetMapping("/gitAddTest")
    public ModelAndView gitAddTest(HttpServletRequest request) throws IOException {

        //git repo path
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);

        //create temp file
        String fileName = UUID.randomUUID().toString();
        File file = new File(dirPath+"/"+fileName+".txt");
        FileUtils.writeStringToFile(file, "testing it...", String.valueOf(StandardCharsets.UTF_8));

        //add
        Object result = null;
        try (Git git = Git.open(gitDir)) {
            AddCommand add = git.add();
            add.addFilepattern(fileName+".txt").call();
            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);
        return modelAndView;
    }

    @GetMapping("/gitCommitTest")
    public ModelAndView gitCommitTest(HttpServletRequest request) throws IOException {

        //git repo path
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);

        // commit
        Object result = null;
        try (Git git = Git.open(gitDir)) {
            git.commit().setMessage("JGIT commit test").call();

            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);
        return modelAndView;
    }

    @GetMapping("/gitPushTest")
    public ModelAndView gitPushTest(HttpServletRequest request) throws IOException {

        //git repo path
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);

        //set username, access token
        CredentialsProvider credentialsProvider
                = new UsernamePasswordCredentialsProvider(
                "313cokr@gmail.com"
                , "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"); //access token

        //push
        Object result = null;
        try (Git git = Git.open(gitDir)) {
            git.push()
                    .setCredentialsProvider(credentialsProvider)
                    .setRemote("https://github.com/313DEVGRP/Java-Service-Tree-Framework-Auto-Code.git")
                    .setRefSpecs(new RefSpec("dev"))
                    .call();

            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);
        return modelAndView;
    }

    @GetMapping("/gitBranchMergeTest")
    public ResponseEntity<String> gitBranchMergeTest(HttpServletRequest request) throws GitAPIException, IOException {

        //git repo path
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);

        //set username, access token
        CredentialsProvider credentialsProvider
                = new UsernamePasswordCredentialsProvider(
                "313cokr@gmail.com"
                , "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"); //access token


        String branchName = "dev";

        try (Git git = Git.open(gitDir)) {
            List<Ref> branchList = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();

            // Check if the branch already exists
            boolean branchExists = branchList.stream().anyMatch(ref -> ref.getName().endsWith("heads/" + branchName));

            // Create branch if it doesn't exist
            if (!branchExists) {
                git.branchCreate().setName(branchName).call();
            }

            // Checkout and merge
            git.checkout().setName(branchName).call();
            ObjectId mergeBase = git.getRepository().resolve("live");

            MergeResult merge = git.merge()
                    .include(mergeBase)
                    .setCommit(true)
                    .setFastForward(MergeCommand.FastForwardMode.NO_FF)
                    .setMessage("Merged changes")
                    .call();

            // Push if merge was successful
            if (merge.getMergeStatus().isSuccessful()) {
                git.push()
                        .setCredentialsProvider(credentialsProvider)
                        .setRemote("stg")
                        .setRefSpecs(new RefSpec(branchName))
                        .call();
            }

            return ResponseEntity.ok("Branch merge and push completed successfully.");

        } catch (GitAPIException | IOException e) {
            log.error("Error during branch merge operation: ", e);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body("Error during branch merge operation");
        }
    }

}
