/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.cron;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.scheduling.support.CronExpression;

public class CronLocalDateTimes {
    private final List<LocalDateTime> localDateTimes;
    private static final int LIMIT_COUNT = 10;

    public CronLocalDateTimes(String cronExpression) {
        CronExpression expression = CronExpression.parse((String)cronExpression);
        this.localDateTimes = Stream.iterate(LocalDateTime.now(), arg_0 -> ((CronExpression)expression).next(arg_0)).skip(1L).limit(10L).collect(Collectors.toList());
        if (this.localDateTimes.isEmpty()) {
            throw new IllegalArgumentException("\uac12\uc774 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (this.localDateTimes.size() < 2) {
            throw new IllegalArgumentException("\ube44\uad50 \ub300\uc0c1\uc774 \ub108\ubb34 \uc801\uc2b5\ub2c8\ub2e4.");
        }
    }

    public boolean hasCloseTimeDifferenceInSeconds(int seconds) {
        return IntStream.range(0, this.localDateTimes.size() - 1).anyMatch(i -> Duration.between((Temporal)this.localDateTimes.get(i), (Temporal)this.localDateTimes.get(i + 1)).toSeconds() < (long)seconds);
    }

    public List<String> simulateResult() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return this.localDateTimes.stream().map(dateTimeFormatter::format).collect(Collectors.toList());
    }
}

