/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.mapping.domain;

import org.springframework.data.annotation.Id;
import org.springframework.data.redis.core.RedisHash;

@RedisHash(value="state")
public class State {
    @Id
    private String id;
    private String name;
    private String categoryMappingId;

    State(String id, String name, String categoryMappingId) {
        this.id = id;
        this.name = name;
        this.categoryMappingId = categoryMappingId;
    }

    public static StateBuilder builder() {
        return new StateBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategoryMappingId() {
        return this.categoryMappingId;
    }

    public static class StateBuilder {
        private String id;
        private String name;
        private String categoryMappingId;

        StateBuilder() {
        }

        public StateBuilder id(String id) {
            this.id = id;
            return this;
        }

        public StateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StateBuilder categoryMappingId(String categoryMappingId) {
            this.categoryMappingId = categoryMappingId;
            return this;
        }

        public State build() {
            return new State(this.id, this.name, this.categoryMappingId);
        }

        public String toString() {
            return "State.StateBuilder(id=" + this.id + ", name=" + this.name + ", categoryMappingId=" + this.categoryMappingId + ")";
        }
    }
}

