/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@RefreshScope
public class KafkaConfig {
    @Value(value="${spring.kafka.bootstrap-servers:Kafka00Service:9094,Kafka01Service:9094,Kafka02Service:9094}")
    private String bootstrapServers;
    @Value(value="${spring.kafka.topic.reqadd:REQADD}")
    private String reqAddTopic;

    @Bean
    public KafkaAdmin kafkaAdmin() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("bootstrap.servers", this.bootstrapServers);
        return new KafkaAdmin(configs);
    }

    @Bean
    public AdminClient kafkaAdminClient(KafkaAdmin kafkaAdmin) {
        return AdminClient.create((Map)kafkaAdmin.getConfigurationProperties());
    }

    @Bean
    public NewTopic reqAddTopic() {
        return new NewTopic(this.reqAddTopic, 3, 1);
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate(ProducerFactory<String, String> producerFactory) {
        return new KafkaTemplate(producerFactory);
    }

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", this.bootstrapServers);
        configs.put("key.serializer", StringSerializer.class);
        configs.put("value.serializer", StringSerializer.class);
        configs.put("acks", "all");
        configs.put("retries", 3);
        configs.put("linger.ms", 10);
        configs.put("compression.type", "snappy");
        configs.put("enable.idempotence", true);
        configs.put("buffer.memory", 0x2000000);
        return new DefaultKafkaProducerFactory(configs);
    }
}

