function drawStackedHorizontalBarChart(target, yAxis, seriesData) {
	var chartDom = document.getElementById(target);

	let myChart = echarts.init(chartDom);

	const option = {
		tooltip: {
			trigger: 'axis',
			axisPointer: {
				type: 'shadow' // 'line' or 'shadow'. 기본값은 'shadow'
			},
			formatter: function (params) {
				const tooltip = params.reduce((acc, param) => {
					const { marker, seriesName, value } = param;
					acc += `${marker}${seriesName}: ${value}<br/>`;
					return acc;
				}, '');

				const totalCount = params.reduce((acc, param) => acc + param.value, 0);
				const totalTooltip = `Total: ${totalCount}<br/>`;

				return totalTooltip + tooltip;
			}
		},
		legend: {
			left: 'left',
			// data: statusTypes,
			textStyle: {
				color: 'white',
				fontSize: 11
			}
		},
		grid: {
			left: '3%',
			right: '4%',
			bottom: '3%',
			containLabel: true
		},
		xAxis: {
			type: 'value',
			axisLabel: {
				textStyle: {
					color: 'white',
					fontWeight: "",
					fontSize: "11"
				}
			},
			splitLine: {
				lineStyle: {
					type: 'dashed',
					color: 'white',
					width: 0.2,
					opacity: 0.5
				}
			}
		},
		yAxis: {
			type: yAxis['type'],
			data: yAxis['data'],
			axisLabel: {
				textStyle: {
					color: 'white',
					fontWeight: "",
					fontSize: "11"
				},
				formatter: function (value) {
					if (value.length > 15) { // 길이가 15보다 크면 생략
						return value.substr(0, 15) + '...'; // 일부만 표시하고 "..." 추가
					} else {
						return value;
					}
				}
			}
		},
		series: seriesData.map(element => {
			return {
				name: element.name,
				type: element.type,
				stack: 'total',
				label: {
					show: true
				},
				emphasis: {
					focus: 'series'
				},
				data: element.data
			};
		})
	};

	option && myChart.setOption(option);

	window.addEventListener('resize', function () {
		myChart.resize();
	});

	return myChart;
}