////////////////////////////////////////////////////////////////////////////////////////
//Global Variables
////////////////////////////////////////////////////////////////////////////////////////
const PAGE_UNIT = 5;
const SWIPER_UNIT = 5;

let state = {
	pageIndex: 1,
	total: 0,
	newsletters: [],
	search: {},
};

////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		[
			"../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js",
			"../cover/css/newsletters.css"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			// setSideMenu("sidebar_menu_system", "sidebar_menu_system_provision");
			$("#sidebar").hide();
			$(".wrap").css("margin", 0);
			$(".widget").widgster();
			$("#footer").load("/cover/html/template/landing-footer.html");

			//api로 기사 정보 들고오기 const newsletters
			initNewsletters();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}

// 초기화
function initNewsletters() {
	newslettersAuthAdminCheck();

	const tag = new URL(location.href).searchParams.get("tag");
	if (tag) state.search.c_newsletter_etc = tag;

	updateTotalCount();
	loadNewsletters();
	loadPopularNewsletters();

	$("#more-article").on("click", loadNewsletters);
}

// 태그 클릭 시
function tagClick(tag) {
	console.log("Filter by tag:", tag);

	$("#newsletters-articles").empty();
	state.pageIndex = 1;
	state.search.c_newsletter_etc = tag;

	updateTotalCount();
	loadNewsletters();

	const newUrl = `./template.html?page=newsletters&tag=${encodeURIComponent(tag)}`;
	history.pushState(null, null, newUrl);
}

// 전체 기사 수
function updateTotalCount() {
	$.ajax({
		url: "/auth-anon/api/cover/newsletter/countNewsletters",
		type: "GET",
		data: state.search,
		success: (count) => {
			state.total = count;
			toggleMoreButton();
		},
		error: handleError("기사를 불러오는 중 오류가 발생했습니다."),
	});
}

// 기사 목록 불러오기
function loadNewsletters() {
	$.ajax({
		url: "/auth-anon/api/cover/newsletter/getNewsletters",
		type: "GET",
		data: {
			...state.search,
			pageIndex: state.pageIndex,
			pageUnit: PAGE_UNIT,
		},
		success: (data) => {
			state.newsletters = data;
			data.forEach(renderNewsletter);
			toggleMoreButton();
			state.pageIndex++;
		},
		error: handleError("기사를 불러오는 중 오류가 발생했습니다."),
	});
}

// 인기 뉴스레터(swiper) 불러오기
function loadPopularNewsletters() {
	$.ajax({
		url: "/auth-anon/api/cover/newsletter/getPopularNewsletters",
		type: "GET",
		data: {
			pageIndex: 1,
			pageUnit: SWIPER_UNIT
		},
		success: (data) => {
			const articles = data.map(formatNewsletter);
			renderSwipers(articles);
			initSwiperControls();
		},
		error: handleError("기사를 불러오는 중 오류가 발생했습니다."),
	});
}

// Swiper 포맷 변환
function formatNewsletter(item) {
	return {
		articleHref: `./template.html?page=${item.c_newsletter_slug}&id=${item.c_id}`,
		c_id: item.c_id,
		alt: item.c_newsletter_thumbnail_alt,
		src: item.c_newsletter_thumbnail_url,
		title: item.c_newsletter_title,
		content: item.c_newsletter_contents,
		buttons: item.c_newsletter_etc ? item.c_newsletter_etc.split(",") : [],
		date: `${item.c_newsletter_created.year}.${item.c_newsletter_created.monthValue}.${item.c_newsletter_created.dayOfMonth}`,
		hit: item.c_newsletter_hit,
	};
}

// Swiper 렌더링
function renderSwipers(articles) {
	const container = $("#swiper-wrapper").empty();

	articles.forEach((item, idx) => {
		const swiper = document.createElement("div");
		swiper.classList.add("swiper-slide", "relative", "flex-shrink-0", "w-257px", "h-full", "group", "md:w-1/2", "sm:w-full");
		if (item.src === null || item.src === "") {
			item.src = "/cover/img/img-onerror.png";
		}

		swiper.innerHTML = `
      <div class="relative box-border w-full overflow-hidden border-solid border-1px border-radius-4 border-color-dedfe7">
        <a href="${item.articleHref}" class="d-flex border-radius-4 bg-cover bg-no-repeat relative block w-full h-140px overflow-hidden">
          <img alt="${item.alt}" class="border-radius-md w-full h-full object-fit-contain group-hover:scale-105 ease-in-out duration-300" src="${item.src}" />
        </a>
        <div class="absolute d-flex flex-col align-items-center justify-content-center overflow-hidden w-8 h-8 border-radius-tr-none border-radius-tl-3 border-radius-br-3 border-radius-bl-none border-1px border-color-dedfe7 bg-white"
             style="top: -1px; left: -1px">
          <b class="relative line-height-23px">${idx + 1}</b>
        </div>
      </div>
      <div class="mt-4 d-flex flex-col align-items-flex-start justify-content-flex-start align-self-stretch md:gap-0">
        <div class="d-flex flex-col align-items-flex-start justify-content-flex-start align-self-stretch gap-3">
          <a href="${item.articleHref}">
            <div class="d-flex flex-col align-items-flex-start justify-content-flex-start align-self-stretch gap-2px">
              <h4 class="line-clamp-2 mb-2px text-4 font-bold line-height-23px md:text-4">
                <span class="title-background-gradient group-hover:title-background-gradient">
                  ${item.title}
                </span>
              </h4>
              <div class="relative align-self-stretch overflow-hidden text-14px line-height-23px line-clamp-2 md:text-3">
                ${item.content}
              </div>
            </div>
          </a>
          <div class="d-flex flex-row flex-wrap align-items-center justify-content-flex-start align-self-stretch text-13px gap-1 md:overflow-hidden md:h-22px" id="article-buttons">
            ${item.buttons.map((btn) => `
              <button type="button" onclick="tagClick('${btn}')"
                class="text-13px font-color-636773 bg-f2f2f2 font-normal line-height-23px border-radius-md px-2 py-2px md:text-3 md:line-height-18px">
                #${btn}
              </button>`).join("")}
          </div>
        </div>
        <div class="relative d-flex mt-4 h-px bg-dedfe7 w-full md:hidden"></div>
        <div class="d-flex flex-row align-items-center justify-content-flex-start align-self-stretch px-0 pb-0 pt-2 text-14px">
          <div class="box-border d-flex h-8 flex-1 flex-row align-items-center justify-content-flex-start gap-6px py-0 pl-0 pr-4">
            <div class="relative h-5 text-13px md:text-3">
              <div class="d-flex flex-row align-items-center justify-content-flex-start gap-6px">
                <div class="relative">${item.date}</div>
                <div class="only-mobile hidden relative h-2 w-px bg-dedfe7"></div>
                <div class="only-mobile hidden d-flex flex-row align-items-center justify-content-flex-start gap-1px">
                  <div class="relative">조회수</div>
                  <div class="relative">${item.hit}</div>
                </div>
              </div>
            </div>
          </div>
          <div class="contents h-8 w-8 md:hidden">
            <button type="button" onclick="popShare('${item.c_id}');">
              <img alt="share" aria-label="공유" loading="lazy" width="24" height="24"
                   class="w-5" src="https://www.elancer.co.kr/_next/static/media/share.f335e865.svg" />
            </button>
          </div>
        </div>
      </div>
    `;
		container.append(swiper);
	});
}

// Swiper 제어
function initSwiperControls() {
	const slider = document.getElementById("swiper-wrapper");
	const totalSlides = document.querySelectorAll(".swiper-slide").length;
	let index = 0;

	function showSlide(i) {
		const slideWidth = document.getElementById("swiper").clientWidth;
		slider.style.transform = `translate3d(${-i * slideWidth}px, 0, 0)`;
		slider.style.transition = "transform 0.3s ease-in-out";
	}

	$("#next")
		.off("click")
		.on("click", () => {
			index = (index + 1) % totalSlides;
			showSlide(index);
		});

	$("#prev")
		.off("click")
		.on("click", () => {
			index = (index - 1 + totalSlides) % totalSlides;
			showSlide(index);
		});
}

//  Newsletter 렌더링
function renderNewsletter(item) {
	const articleContainer = document.getElementById("newsletters-articles");
	const article = document.createElement("div");
	article.classList.add("mb-6", "md:mb-0");
	if (item.c_newsletter_thumbnail_url === null || item.c_newsletter_thumbnail_url === "" || item.c_newsletter_thumbnail_url === undefined) {
		item.c_newsletter_thumbnail_url = "/cover/img/img-onerror.png";
		item.c_newsletter_thumbnail_alt = "이미지 없음";
	}

	if (articleContainer.children.length > 0) {
		const divider = document.createElement("div");
		divider.className = "relative d-flex my-6 h-px bg-dedfe7 w-full md:hidden";
		articleContainer.appendChild(divider);
	}

	article.innerHTML = `
    <div class="d-flex flex-row align-self-stretch justify-content-center align-items-center relative gap-4 group md:flex-col">
      <a href="./template.html?page=${item.c_newsletter_slug}&id=${item.c_id}"
         class="d-flex flex-col min-w-96px w-268px h-150px border-radius-md overflow-hidden md:w-full">
        <img alt="${item.c_newsletter_thumbnail_alt}"
             class="border-radius-md w-full h-full object-fit-cover group-hover:scale-105 ease-in-out duration-300"
             src="${item.c_newsletter_thumbnail_url}" />
      </a>
      <div class="d-flex flex-col flex-1 align-items-flex-start justify-content-flex-start align-self-stretch gap-3 md:gap-2">
        <div className="d-flex flex-col align-items-flex-start justify-content-flex-start align-self-stretch gap-2px">
          <a href="./template.html?page=newsletters&category=${item.c_newsletter_category}">
            <button tabIndex="0" class="text-15px font-bold md:text-3 font-color-orange" type="button">
              ${item.c_newsletter_category}
            </button>
          </a>
          <a href="./template.html?page=${item.c_newsletter_slug}&id=${item.c_id}">
            <div class="d-flex flex-col align-items-flex-start justify-content-flex-start gap-2px">
              <h4 class="line-clamp-2 mb-2px text-5 font-bold line-height-30px md:text-4 md:line-height-20px">
                <span class="title-background-gradient group-hover:title-background-gradient">
                  ${item.c_newsletter_title}
                </span>
              </h4>
              <div class="line-clamp-1 text-15px line-height-23px md:line-height-18px">
                ${item.c_newsletter_contents}
              </div>
            </div>
          </a>
        </div>
        <div class="d-flex flex-row flex-wrap align-items-center justify-content-flex-start align-self-stretch text-center gap-1" id="article-buttons">
          ${item.c_newsletter_etc
						.split(",")
						.map(
							(btn) => `
            <button type="button" onclick="tagClick('${btn}')"
              class="text-14px font-color-636773 bg-f2f2f2 font-normal line-height-23px border-radius-md px-2 py-2px md:line-height-18px md:text-3">
              #${btn}
            </button>`
						)
						.join("")}
        </div>
        <div class="d-flex flex-row align-items-center justify-content-flex-start align-self-stretch text-14px gap-2 ">
          <div class="d-flex flex-1 flex-row align-items-center justify-content-flex-start gap-2">
            <div class="relative line-height-23px md:line-height-20px md:text-3">${item.c_newsletter_created.year}.${
		item.c_newsletter_created.monthValue
	}.${item.c_newsletter_created.dayOfMonth}</div>
            <div class="relative h-3 w-px bg-f2f2f2"></div>
            <div class="d-flex flex-row align-items-center justify-content-flex-start gap-2px">
              <div class="relative line-height-23px md:line-height-20px md:text-3">조회수</div>
              <div class="relative line-height-23px md:line-height-20px md:text-3">${item.c_newsletter_hit}</div>
            </div>
          </div>
          <div class="w-4">
            <button tabIndex="0" type="button" onclick="popShare('${item.c_id}');">
              <img alt="share" aria-label="공유" loading="lazy" width="24" height="24" decoding="async"
                   class="w-5" src="https://www.elancer.co.kr/_next/static/media/share.f335e865.svg" />
            </button>
          </div>
        </div>
      </div>
    </div>
  `;
	articleContainer.appendChild(article);
}

// 관리자 권한 체크
function newslettersAuthAdminCheck() {
	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				console.log("[ landing :: authUserCheck ] userName = " + json.preferred_username);
				console.log("[ landing :: authUserCheck ] sub = " + json.sub);
				console.log("[ landing :: authUserCheck ] roles = " + json.realm_access.roles);
				console.log("[ landing :: authUserCheck ] email = " + json.email);
				console.log("[ landing :: authUserCheck ] name = " + json.name);
				userName = json.preferred_username;
				permissions = json.realm_access.roles;
				userID = json.sub;
				userEmail = json.email;
				fullName = json.name;

				if (isEmpty(permissions) == false && permissions.indexOf("ROLE_ADMIN") != -1) {
					const newslettersAdminButtons = document.getElementById("newsletters_admin_buttons");
					newslettersAdminButtons.classList.remove("hidden");
				}
			}
		}
	});
}

// 유틸
function toggleMoreButton() {
	if (state.total <= PAGE_UNIT * state.pageIndex) {
		$("#more-article").hide();
	} else {
		$("#more-article").show();
	}
}
function handleError(message) {
	return (e) => {
		console.error(e);
		jError(message);
	};
}




let currentUrl = "";
// 공유 모달 열기
function popShare(c_id) {
	console.log(c_id);
	currentUrl = 'https://313.co.kr/cover/template.html?page=newslettersDetail&id=' + c_id;
	document.getElementById('shareUrlText').textContent = currentUrl;

	const modal = document.getElementById('shareModal');
	modal.classList.remove("hidden");

	// 포커스 이동 (접근성)
	const shareModal = document.getElementById('shareModal');
	if (shareModal && typeof shareModal.focus === "function") {
		shareModal.focus();
	}

	// 배경 클릭 시 닫기
	modal.addEventListener('click', (e) => {
		if (e.target === modal) closeModal();
	});
}

// 모달 닫기
function closeModal() {
	document.getElementById('shareModal').classList.add("hidden");
}

// 네이버 공유
function shareToNaver() {
	const shareUrl = `http://blog.naver.com/openapi/share?url=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'naver', 'width=500,height=400');
}

// 트위터 공유
function shareToTwitter() {
	const shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'twitter', 'width=500,height=400');
}

// 페이스북 공유
function shareToFacebook() {
	const shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'facebook', 'width=500,height=400');
}

// 링크 복사
function copyUrl() {
	navigator.clipboard.writeText(currentUrl)
		.then(() => jSuccess('링크가 복사되었습니다.'))
		.catch(() => jError('복사 실패. 직접 복사해주세요.'));
}