////////////////////////////////////////////////////////////////////////////////////////
//Global Variables
////////////////////////////////////////////////////////////////////////////////////////
// URL 파라미터에서 id 값 가져오기
const id = new URL(location.href).searchParams.get("id");

////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		[
			"../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js",
			"../cover/css/newsletters.css"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			// setSideMenu("sidebar_menu_system", "sidebar_menu_system_provision");
			$("#sidebar").hide();
			$(".wrap").css("margin", 0);
			$(".widget").widgster();
			$("#footer").load("/cover/html/template/landing-footer.html");

			initNewslettersDetail();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}

function initNewslettersDetail() {
	// 관리자 인증
	newslettersAuthAdminCheck();

	// 뉴스레터 불러오기
	loadNewsletter(id);

	// 수정버튼
	// editButton(id);

	// 삭제버튼
	// removeButton(id);
	// 모달 초기화
	initModal();

	// 실시간 인기 게시물 불러오기
	loadTrendingNewsletters();

}

function loadNewsletter(id) {
	$.ajax({
		url: '/auth-anon/api/cover/newsletter/getNewsletter/' + id,
		type: "GET",
		statusCode: {
			200: function (data) {
				document.getElementById("c_newsletter_title").innerText = data.c_newsletter_title;
				document.getElementById("c_newsletter_category").innerText = data.c_newsletter_category;
				document.getElementById("c_newsletter_created").innerText = data.c_newsletter_created.year + "." + data.c_newsletter_created.monthValue + "." + data.c_newsletter_created.dayOfMonth;
				document.getElementById("c_newsletter_contents").innerHTML = data.c_newsletter_contents;
				document.getElementById("c_newsletter_hit").innerText = data.c_newsletter_hit;
				document.getElementById("c_newsletter_tags").innerHTML = data.c_newsletter_etc.split(',').map((btn) => `
								<button tabindex="0"
												type="button"
												onclick="tagClick('${btn}')"
												class="text-14px font-color-636773 bg-f2f2f2 font-normal line-height-23px border-radius-md px-2 py-2px md:line-height-18px md:text-3">
												#${btn}
								</button>`
				).join('');
			}
		},
		error: function (e) {
			console.error("Error:", e);
			jError("기사를 불러오는 중 오류가 발생했습니다.");
		}
	});
}

function renderTrendingNewsletters(articles) {
	const container = document.getElementById("trending-newsletters-container");

	articles.forEach((item, idx) => {
		const singleArticle = document.createElement("div");
		singleArticle.classList.add("d-flex", "flex-col", "justify-content-flex-start", "align-items-center", "gap-2", "col-lg-4", "group");
		singleArticle.innerHTML = `
<!--	사진	-->
						<div class="relative box-border w-full overflow-hidden">
							<a href="${item.articleHref}"
								 class="border-radius-4 bg-cover bg-no-repeat relative overflow-hidden">
								<img alt="${item.alt}"
										 class="border-radius-md group-hover:scale-105 ease-in-out duration-300"
										 src="${item.src}">
							</a>
						</div>
						<!--	제목&내용	-->
						<div class="d-flex flex-col align-items-flex-start justify-content-flex-start align-self-stretch">
							<a href="#">
								<button tabindex="0"
												class="text-14px font-bold font-color-orange"
												type="button">
									${item.category}
								</button>
							</a>
							<a href="${item.articleHref}">
								<h4 class="line-clamp-2 text-4 font-bold line-height-23px">
									<span class="title-background-gradient group-hover:title-background-gradient">
										${item.title}
									</span>
								</h4>
								<div class="line-clamp-1 text-3">
									${item.content}
								</div>
							</a>
						</div>
						<!--	버튼 리스트	-->
						<div class="d-flex flex-row flex-wrap justify-content-flex-start align-items-center align-self-stretch text-center gap-1">
							${item.buttons.map((btn) => 
							`
							<button tabindex="0"
											type="button"
											onclick="tagClick('${btn}')"
											class="text-3 font-color-636773 bg-f2f2f2 font-normal border-radius-md px-2 py-2px">
								#${btn}
							</button>
							`).join('')}
						</div>
						<!--	게시일&조회수	-->
						<div class="d-flex flex-row justify-content-flex-start align-items-center align-self-stretch text-3 gap-2">
							<div>${item.date}</div>
							<div class="relative h-3 w-px bg-dedfe7"></div>
							<div>조회수 ${item.hit}</div>
						</div>
		`;
		container.appendChild(singleArticle);
	});
}

// 인기 뉴스레터 불러오기
function loadTrendingNewsletters() {
	$.ajax({
		url: "/auth-anon/api/cover/newsletter/getPopularNewsletters",
		type: "GET",
		data: {
			pageIndex: 1,
			pageUnit: 3
		},
		statusCode: {
			200: function (data) {
				console.log(data);
				let articles = data.map((item) => ({
					articleHref: `./template.html?page=${item.c_newsletter_slug}&id=${item.c_id}`,
					category: item.c_newsletter_category,
					alt: item.c_newsletter_thumbnail_alt,
					src: item.c_newsletter_thumbnail_url,
					title: item.c_newsletter_title,
					content: item.c_newsletter_contents,
					buttons: item.c_newsletter_etc ? item.c_newsletter_etc.split(",") : [],
					date: `${item.c_newsletter_created.year}.${item.c_newsletter_created.monthValue}.${item.c_newsletter_created.dayOfMonth}`,
					hit: item.c_newsletter_hit
				}));
				renderTrendingNewsletters(articles);
			}
		},
		error: function (e) {
			console.error("Error:", e);
			jError("기사를 불러오는 중 오류가 발생했습니다.");
		}
	});
}

// 수정버튼
function editButton(id) {
	window.location.href = "./template.html?page=newslettersWriter&id=" + id;
}

// 삭제버튼
function removeButton(id) {
	$.ajax({
		url: "/auth-anon/api/cover/newsletter/removeNewsletter/" + id,
		type: "DELETE",
		contentType: "application/json;charset=UTF-8",
		dataType: "json",
		statusCode: {
			200: function () {
				jSuccess("뉴스레터가 성공적으로 삭제되었습니다.");
				setTimeout(function () {
					window.location.href = "./template.html?page=newsletters";
				}, 1500);
			}
		},
		error: function (e) {
			console.error("Error:", e);
			jError("뉴스레터 삭제 중 오류가 발생했습니다.");
		}
	});
}

// 태그 클릭 시
function tagClick(tag) {
	window.location.href = `./template.html?page=newsletters&tag=${encodeURIComponent(tag)}`;
}


// 공유 모달 열기
function popShare() {
	currentUrl = 'https://313.co.kr/cover/template.html?page=newslettersDetail&id=' + id;
	document.getElementById('shareUrlText').textContent = currentUrl;

	const modal = document.getElementById('shareModal');
	modal.classList.remove("hidden");

	// 포커스 이동 (접근성)
	const shareModal = document.getElementById('shareModal');
	if (shareModal && typeof shareModal.focus === "function") {
		shareModal.focus();
	}

	// 배경 클릭 시 닫기
	modal.addEventListener('click', (e) => {
		if (e.target === modal) closeModal();
	});
}

// 모달 닫기
function closeModal() {
	document.getElementById('shareModal').classList.add("hidden");
}

// 네이버 공유
function shareToNaver() {
	const shareUrl = `http://blog.naver.com/openapi/share?url=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'naver', 'width=500,height=400');
}

// 트위터 공유
function shareToTwitter() {
	const shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'twitter', 'width=500,height=400');
}

// 페이스북 공유
function shareToFacebook() {
	const shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentUrl)}`;
	window.open(shareUrl, 'facebook', 'width=500,height=400');
}

// 링크 복사
function copyUrl() {
	navigator.clipboard.writeText(currentUrl)
		.then(() => jSuccess('링크가 복사되었습니다.'))
		.catch(() => jError('복사 실패. 직접 복사해주세요.'));
}


function initModal() {
	const backdrop = document.getElementById("modalBackdrop");
	const modal = backdrop.querySelector('.modal');
	const modalTitleEl = document.getElementById("modalTitle");
	const modalDescEl = document.getElementById("modalDesc");
	const modalConfirmBtn = document.getElementById("modalConfirmBtn");
	const modalCancelBtn = document.getElementById("modalCancelBtn");

	let lastFocused = null;
	let currentOnConfirm = null;
	let currentOnCancel = null;

	function showModal({title, message, confirmText, cancelText, confirmClass="primary", onConfirm, onCancel}) {
		modalTitleEl.textContent = title;
		modalDescEl.textContent = message;
		modalConfirmBtn.textContent = confirmText || "확인";
		modalCancelBtn.textContent = cancelText || "취소";

		modalConfirmBtn.className = `btn-${confirmClass} text-5 font-color-white font-normal line-height-30px border-radius-4 px-4 py-2`;
		modalCancelBtn.className = `btn-default text-5 font-color-white font-normal line-height-30px border-radius-4 px-4 py-2`;

		lastFocused = document.activeElement;
		currentOnConfirm = onConfirm;
		currentOnCancel = onCancel;

		backdrop.classList.remove("hidden");
		backdrop.setAttribute("aria-hidden", "false");

		if (modal && typeof modal.focus() === "function") {
			modal.focus();
		}

		modalConfirmBtn.onclick = () => {
			hideModal();
			if (onConfirm) onConfirm();
		};
		modalCancelBtn.onclick = () => {
			hideModal();
			if (onCancel) onCancel();
		};
	}
	function hideModal() {
		backdrop.classList.add("hidden");
		backdrop.setAttribute("aria-hidden", "true");
		if (lastFocused && typeof lastFocused.focus === "function") lastFocused.focus();
	}
	backdrop.addEventListener("click", e => {
		if (e.target === backdrop) {
			hideModal();
			if (currentOnCancel) currentOnCancel();
		}
	});
	document.addEventListener("keydown", e => {
		if (e.key === "Escape" && backdrop.attributes.getNamedItem("aria-hidden").value === "false") {
			hideModal();
			if (currentOnCancel) currentOnCancel();
		}
	});

	document.getElementById("edit_newsletter").addEventListener("click", e => {
		showModal({
			title: "뉴스레터 수정",
			message: "뉴스레터를 수정하시겠습니까?",
			confirmText: "수정",
			cancelText: "취소",
			confirmClass: "primary",
			onConfirm: () => {
				setTimeout(function () {
					editButton(id);
				}, 200);
			}
		});
	});
	document.getElementById("remove_newsletter").addEventListener("click", e => {
		showModal({
			title: "뉴스레터 삭제",
			message: "뉴스레터를 삭제하시겠습니까?",
			confirmText: "삭제",
			cancelText: "취소",
			confirmClass: "danger",
			onConfirm: () => {
				setTimeout(function () {
					removeButton(id);
				}, 200);
			}
		});
	});
}

// 관리자 인증
function newslettersAuthAdminCheck() {
	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				console.log("[ landing :: authUserCheck ] userName = " + json.preferred_username);
				console.log("[ landing :: authUserCheck ] sub = " + json.sub);
				console.log("[ landing :: authUserCheck ] roles = " + json.realm_access.roles);
				console.log("[ landing :: authUserCheck ] email = " + json.email);
				console.log("[ landing :: authUserCheck ] name = " + json.name);
				userName = json.preferred_username;
				permissions = json.realm_access.roles;
				userID = json.sub;
				userEmail = json.email;
				fullName = json.name;

				if (isEmpty(permissions) == false && permissions.indexOf("ROLE_ADMIN") != -1) {
					const newslettersAdminButtons = document.getElementById("newsletters_admin_buttons");
					newslettersAdminButtons.classList.remove("hidden");
				}
			}
		}
	});
}