/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.blog.controller;

import com.arms.api.blog.model.entity.BlogDTO;
import com.arms.api.blog.model.entity.BlogEntity;
import com.arms.api.blog.model.vo.BlogVO;
import com.arms.api.blog.service.BlogService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/blog"})
public class BlogController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlogController.class);
    private final BlogService blogService;

    @PostMapping
    public ResponseEntity<Long> addBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok((Object)this.blogService.addBlog(blogDTO));
    }

    @PutMapping
    public ResponseEntity<Long> updateBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok((Object)this.blogService.updateBlog(blogDTO));
    }

    @DeleteMapping(value={"/{c_id}"})
    public ResponseEntity<Long> removeBlog(@PathVariable Long c_id) {
        return ResponseEntity.ok((Object)this.blogService.removeBlog(c_id));
    }

    @PostMapping(value={"/get"})
    public ResponseEntity<BlogEntity> getBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok((Object)this.blogService.getBlog(blogDTO));
    }

    @PostMapping(value={"/popular"})
    public ResponseEntity<List<BlogEntity>> getBlogListByViewCountDesc(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(this.blogService.getBlogListByViewCountDesc(blogDTO));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<BlogVO> getBlogListBySearchAfter(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok((Object)this.blogService.searchBlog(blogDTO));
    }

    @Generated
    public BlogController(BlogService blogService) {
        this.blogService = blogService;
    }
}

