/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.vo.IssueFieldData;
import com.arms.api.issue.almapi.model.vo.IssueLink;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.CloudJiraIssueRawDataVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CloudJiraIssueVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJiraIssueVO.class);
    private CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO;
    private ServerInfo serverInfo;
    private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;
    private boolean excludeFromSave;
    private List<Long> linkedIssuePdServiceIds;
    private List<Long> linkedIssuePdServiceVersions;

    public AlmIssueVO toAlmIssueVOByStateCategory(String armsStateCategory) {
        return AlmIssueVO.builder().upperKey(this.cloudJiraIssueRawDataVO.getParentKey()).id(this.cloudJiraIssueRawDataVO.getId()).self(this.cloudJiraIssueRawDataVO.getSelf()).key(this.cloudJiraIssueRawDataVO.getKey()).fields(this.cloudJiraIssueRawDataVO.getFields()).rawData(this.cloudJiraIssueRawDataVO.getRawData()).almIssueWithRequirementDTO(this.almIssueWithRequirementDTO).excludeFromSave(this.excludeFromSave).linkedIssue(this.relationRecentIds()).armsStateCategory(armsStateCategory).linkedIssuePdServiceIds(this.linkedIssuePdServiceIds).linkedIssuePdServiceVersions(this.linkedIssuePdServiceVersions).build();
    }

    public AlmIssueVO toAlmIssueVO() {
        return AlmIssueVO.builder().upperKey(this.cloudJiraIssueRawDataVO.getParentKey()).id(this.cloudJiraIssueRawDataVO.getId()).self(this.cloudJiraIssueRawDataVO.getSelf()).key(this.cloudJiraIssueRawDataVO.getKey()).fields(this.cloudJiraIssueRawDataVO.getFields()).rawData(this.cloudJiraIssueRawDataVO.getRawData()).build();
    }

    public IssueFieldData cloudJiraIssueField() {
        return this.cloudJiraIssueRawDataVO.getFields();
    }

    public String recentId() {
        return this.serverInfo.getConnectId() + "_" + this.cloudJiraIssueRawDataVO.getFields().getProject().getKey() + "_" + this.cloudJiraIssueRawDataVO.getKey();
    }

    public String recentId(String key) {
        return this.serverInfo.getConnectId() + "_" + this.cloudJiraIssueRawDataVO.getFields().getProject().getKey() + "_" + key;
    }

    public CloudJiraIssueVO markAsExcludedFromSave() {
        return CloudJiraIssueVO.builder().cloudJiraIssueRawDataVO(this.cloudJiraIssueRawDataVO).serverInfo(this.serverInfo).almIssueWithRequirementDTO(this.almIssueWithRequirementDTO).excludeFromSave(true).build();
    }

    public CloudJiraIssueVO appliedLinkedIssuePdServiceElement(List<AlmIssueWithRequirementDTO> almIssueWithRequirementDTOS) {
        return CloudJiraIssueVO.builder().cloudJiraIssueRawDataVO(this.cloudJiraIssueRawDataVO).serverInfo(this.serverInfo).almIssueWithRequirementDTO(almIssueWithRequirementDTOS.stream().filter(a -> {
            if (a.getIssueKey() == null) {
                System.out.println(a);
            }
            return a.getIssueKey().equals(this.cloudJiraIssueRawDataVO.getKey());
        }).findFirst().orElseGet(() -> this.almIssueWithRequirementDTO)).linkedIssuePdServiceIds(almIssueWithRequirementDTOS.stream().map(AlmIssueWithRequirementDTO::getServiceId).toList()).linkedIssuePdServiceVersions(almIssueWithRequirementDTOS.stream().flatMap(a -> a.getVersions().stream()).toList()).excludeFromSave(this.excludeFromSave).build();
    }

    public Set<String> relationRecentIds() {
        List<IssueLink> issueRelations = this.cloudJiraIssueRawDataVO.getFields().getIssuelinks();
        Set<String> set = issueRelations.stream().filter(a -> !ObjectUtils.isEmpty((Object)a.getInwardIssue())).map(a -> {
            String projectKey = Arrays.stream(a.getInwardIssue().getKey().split("-")).findFirst().orElseGet(() -> this.almIssueWithRequirementDTO.getProjectKeyOrId());
            return this.almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey, a.getInwardIssue().getKey());
        }).collect(Collectors.toSet());
        set.addAll(issueRelations.stream().filter(a -> !ObjectUtils.isEmpty((Object)a.getOutwardIssue())).map(a -> {
            String projectKey = Arrays.stream(a.getOutwardIssue().getKey().split("-")).findFirst().orElseGet(() -> this.almIssueWithRequirementDTO.getProjectKeyOrId());
            return this.almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey, a.getOutwardIssue().getKey());
        }).collect(Collectors.toSet()));
        return set;
    }

    @Generated
    public static CloudJiraIssueVOBuilder builder() {
        return new CloudJiraIssueVOBuilder();
    }

    @Generated
    public CloudJiraIssueVO() {
    }

    @Generated
    public CloudJiraIssueVO(CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO, ServerInfo serverInfo, AlmIssueWithRequirementDTO almIssueWithRequirementDTO, boolean excludeFromSave, List<Long> linkedIssuePdServiceIds, List<Long> linkedIssuePdServiceVersions) {
        this.cloudJiraIssueRawDataVO = cloudJiraIssueRawDataVO;
        this.serverInfo = serverInfo;
        this.almIssueWithRequirementDTO = almIssueWithRequirementDTO;
        this.excludeFromSave = excludeFromSave;
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
    }

    @Generated
    public CloudJiraIssueRawDataVO getCloudJiraIssueRawDataVO() {
        return this.cloudJiraIssueRawDataVO;
    }

    @Generated
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Generated
    public AlmIssueWithRequirementDTO getAlmIssueWithRequirementDTO() {
        return this.almIssueWithRequirementDTO;
    }

    @Generated
    public boolean isExcludeFromSave() {
        return this.excludeFromSave;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceIds() {
        return this.linkedIssuePdServiceIds;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceVersions() {
        return this.linkedIssuePdServiceVersions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudJiraIssueVO)) {
            return false;
        }
        CloudJiraIssueVO other = (CloudJiraIssueVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloudJiraIssueRawDataVO this$cloudJiraIssueRawDataVO = this.getCloudJiraIssueRawDataVO();
        CloudJiraIssueRawDataVO other$cloudJiraIssueRawDataVO = other.getCloudJiraIssueRawDataVO();
        return !(this$cloudJiraIssueRawDataVO == null ? other$cloudJiraIssueRawDataVO != null : !((Object)this$cloudJiraIssueRawDataVO).equals(other$cloudJiraIssueRawDataVO));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudJiraIssueVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudJiraIssueRawDataVO $cloudJiraIssueRawDataVO = this.getCloudJiraIssueRawDataVO();
        result = result * 59 + ($cloudJiraIssueRawDataVO == null ? 43 : ((Object)$cloudJiraIssueRawDataVO).hashCode());
        return result;
    }

    @Generated
    public static class CloudJiraIssueVOBuilder {
        @Generated
        private CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO;
        @Generated
        private ServerInfo serverInfo;
        @Generated
        private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;
        @Generated
        private boolean excludeFromSave;
        @Generated
        private List<Long> linkedIssuePdServiceIds;
        @Generated
        private List<Long> linkedIssuePdServiceVersions;

        @Generated
        CloudJiraIssueVOBuilder() {
        }

        @Generated
        public CloudJiraIssueVOBuilder cloudJiraIssueRawDataVO(CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO) {
            this.cloudJiraIssueRawDataVO = cloudJiraIssueRawDataVO;
            return this;
        }

        @Generated
        public CloudJiraIssueVOBuilder serverInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            return this;
        }

        @Generated
        public CloudJiraIssueVOBuilder almIssueWithRequirementDTO(AlmIssueWithRequirementDTO almIssueWithRequirementDTO) {
            this.almIssueWithRequirementDTO = almIssueWithRequirementDTO;
            return this;
        }

        @Generated
        public CloudJiraIssueVOBuilder excludeFromSave(boolean excludeFromSave) {
            this.excludeFromSave = excludeFromSave;
            return this;
        }

        @Generated
        public CloudJiraIssueVOBuilder linkedIssuePdServiceIds(List<Long> linkedIssuePdServiceIds) {
            this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
            return this;
        }

        @Generated
        public CloudJiraIssueVOBuilder linkedIssuePdServiceVersions(List<Long> linkedIssuePdServiceVersions) {
            this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
            return this;
        }

        @Generated
        public CloudJiraIssueVO build() {
            return new CloudJiraIssueVO(this.cloudJiraIssueRawDataVO, this.serverInfo, this.almIssueWithRequirementDTO, this.excludeFromSave, this.linkedIssuePdServiceIds, this.linkedIssuePdServiceVersions);
        }

        @Generated
        public String toString() {
            return "CloudJiraIssueVO.CloudJiraIssueVOBuilder(cloudJiraIssueRawDataVO=" + String.valueOf(this.cloudJiraIssueRawDataVO) + ", serverInfo=" + String.valueOf(this.serverInfo) + ", almIssueWithRequirementDTO=" + String.valueOf(this.almIssueWithRequirementDTO) + ", excludeFromSave=" + this.excludeFromSave + ", linkedIssuePdServiceIds=" + String.valueOf(this.linkedIssuePdServiceIds) + ", linkedIssuePdServiceVersions=" + String.valueOf(this.linkedIssuePdServiceVersions) + ")";
        }
    }
}

