/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.poc.service;

import com.arms.api.poc.model.dto.PocDTO;
import com.arms.api.poc.model.entity.PocEntity;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PocServiceImpl
implements PocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PocServiceImpl.class);
    private final EsCommonRepositoryWrapper<PocEntity> esCommonRepositoryWrapper;

    @Override
    public String createPoc(PocDTO pocDTO) {
        PocEntity pocEntity = pocDTO.toPocEntityWithCreate();
        if (pocEntity.getC_poc_full_name() == null || pocEntity.getC_poc_full_name().isEmpty()) {
            String fullName = this.formatFullName(pocEntity);
            pocEntity.setC_poc_full_name(fullName);
        }
        PocEntity save = this.esCommonRepositoryWrapper.save(pocEntity);
        return save.getId();
    }

    @Override
    public PocEntity getPoc(String id) {
        PocEntity pocEntity = this.esCommonRepositoryWrapper.findDocById(id);
        if (pocEntity == null) {
            throw new IllegalArgumentException("POC\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + id);
        }
        return pocEntity;
    }

    @Override
    public PocVO getPocList(PocDTO pocDTO) {
        SimpleQuery<SearchDocDTO> query = SimpleQuery.search(pocDTO).orderBy(SortDTO.builder().field("c_poc_inquiry_date").sortType("desc").build());
        DocumentResultWrapper<PocEntity> docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(query);
        List<PocEntity> pocList = docsBySearchAfter.toDocs();
        Long totalCount = docsBySearchAfter.getTotalHits();
        log.info("POC list fetched: totalCount={}", (Object)totalCount);
        return PocVO.builder().pocEntities(pocList).totalHits(totalCount).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    @Override
    public String updatePoc(PocDTO pocDTO) {
        PocEntity findPocEntity = this.esCommonRepositoryWrapper.findDocById(pocDTO.getId());
        if (findPocEntity == null) {
            throw new IllegalArgumentException("POC\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + pocDTO.getId());
        }
        PocEntity updateEntity = pocDTO.toPocEntityWithUpdate();
        findPocEntity.updatePocEntity(updateEntity);
        PocEntity save = this.esCommonRepositoryWrapper.save(findPocEntity);
        return save.getId();
    }

    @Override
    public String deletePoc(String id) {
        PocEntity pocEntity = this.esCommonRepositoryWrapper.findDocById(id);
        if (pocEntity == null) {
            throw new IllegalArgumentException("POC\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + id);
        }
        this.esCommonRepositoryWrapper.deleteById(id);
        return id;
    }

    private String formatFullName(PocEntity pocEntity) {
        String country;
        String firstName = pocEntity.getC_poc_first_name() != null ? pocEntity.getC_poc_first_name() : "";
        String lastName = pocEntity.getC_poc_last_name() != null ? pocEntity.getC_poc_last_name() : "";
        String string = country = pocEntity.getC_poc_country() != null ? pocEntity.getC_poc_country() : "";
        if (country.equals("KR") || country.equals("JP") || country.equals("CN")) {
            return lastName + " " + firstName;
        }
        return firstName + " " + lastName;
    }

    @Generated
    public PocServiceImpl(EsCommonRepositoryWrapper<PocEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

